/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.handlers;

import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.joml.Vector3f;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="codmod")
public class ContinuumSlicerEvents {
    @SubscribeEvent
    public static void fallEvent(LivingFallEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).getPersistentData().getBoolean("NoFall")) {
            event.setDamageMultiplier(0.0f);
            player.getPersistentData().putBoolean("NoFall", false);
        }
    }

    @SubscribeEvent
    public static void fallingTick(PlayerTickEvent.Post event) {
        Level level;
        if (event.getEntity().getPersistentData().getBoolean("NoFall") && (level = event.getEntity().level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 1.0f), 1.0f), event.getEntity().getX() + 0.5, event.getEntity().getY() + 0.5, event.getEntity().getZ() + 0.5, 8, 0.0, 0.5, 0.0, 20.0);
        }
        if (event.getEntity().isCreative()) {
            event.getEntity().getPersistentData().putBoolean("NoFall", false);
        }
    }
}

