/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import com.mc3699.codmod.registry.CodComponents;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.media.IMedia;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import org.jspecify.annotations.Nullable;

public class OpticalTapeDriveItem
extends Item
implements IMedia {
    public OpticalTapeDriveItem(Item.Properties properties) {
        super(properties);
    }

    public @Nullable String getLabel(HolderLookup.Provider registries, ItemStack stack) {
        return (String)stack.getOrDefault(CodComponents.DISK_LABEL, (Object)"Optical Drive");
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        String label = (String)stack.getOrDefault(CodComponents.DISK_LABEL.get(), (Object)"No Label");
        Long storedSize = (Long)stack.getOrDefault(CodComponents.DISK_SIZE.get(), (Object)0L);
        tooltipComponents.add((Component)Component.literal((String)("Drive Label: " + label)).withStyle(ChatFormatting.AQUA));
        if (data != null) {
            if (data.getUnsafe().contains("diskID")) {
                String idText = data.getUnsafe().getString("diskID");
                String idHex = Integer.toHexString(Integer.parseInt(idText));
                tooltipComponents.add((Component)Component.literal((String)("Drive ID: " + idHex)).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltipComponents.add((Component)Component.literal((String)"Drive ID: Uninitialized").withStyle(ChatFormatting.RED));
        }
        tooltipComponents.add((Component)Component.literal((String)("Size: " + this.formatSize(storedSize))).withStyle(ChatFormatting.GRAY));
    }

    private String formatSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1000.0));
        String unit = String.valueOf("KM".charAt(exp - 1));
        return String.format("%.1f %sB", (double)bytes / Math.pow(1000.0, exp), unit);
    }

    public boolean setLabel(ItemStack stack, @Nullable String label) {
        if (label == null) {
            stack.remove(CodComponents.DISK_LABEL);
        } else {
            stack.set(CodComponents.DISK_LABEL, (Object)label);
        }
        return true;
    }

    public @Nullable Mount createDataMount(ItemStack stack, ServerLevel level) {
        WritableMount mount;
        String diskID;
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        String string = diskID = data.getUnsafe().contains("diskID") ? data.getUnsafe().getString("diskID") : String.valueOf(level.random.nextInt());
        if (!data.getUnsafe().contains("diskID")) {
            stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, customData -> customData.update(nbt -> nbt.putString("diskID", diskID)));
        }
        if ((mount = ComputerCraftAPI.createSaveDirMount((MinecraftServer)level.getServer(), (String)("optical_drive/" + diskID), (long)10000000L)) instanceof WritableMount) {
            WritableMount writableMount = mount;
            try {
                long used = this.calculateMountSize(writableMount, "");
                stack.set(CodComponents.DISK_SIZE, (Object)used);
            }
            catch (IOException e) {
                stack.set(CodComponents.DISK_SIZE, (Object)0L);
            }
        }
        return mount;
    }

    private long calculateMountSize(WritableMount mount, String path) throws IOException {
        long totalSize = 0L;
        ArrayList contents = new ArrayList();
        mount.list(path, contents);
        for (String subPath : contents) {
            String fullPath;
            String string = fullPath = path.isEmpty() ? subPath : path + "/" + subPath;
            if (mount.isDirectory(fullPath)) {
                totalSize += this.calculateMountSize(mount, fullPath);
                continue;
            }
            totalSize += mount.getSize(fullPath);
        }
        return totalSize;
    }
}

