/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.peripheral;

import com.mc3699.codmod.block.opticalDriveInterface.OpticalDriveInterfaceBlockEntity;
import com.mc3699.codmod.item.OpticalTapeDriveItem;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

public class OpticalDriveInterfacePeripheral
implements IPeripheral {
    private final OpticalDriveInterfaceBlockEntity drive;
    private IComputerAccess computer;

    public OpticalDriveInterfacePeripheral(OpticalDriveInterfaceBlockEntity drive) {
        this.drive = drive;
    }

    public String getType() {
        return "optical_interface";
    }

    public void attach(@NotNull IComputerAccess computer) {
        Item item;
        this.computer = computer;
        ItemStack disk = this.drive.getDisk();
        if (!disk.isEmpty() && (item = disk.getItem()) instanceof OpticalTapeDriveItem) {
            OpticalTapeDriveItem media = (OpticalTapeDriveItem)item;
            item = this.drive.getLevel();
            if (item instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)item;
                try {
                    computer.mount("optical", Objects.requireNonNull(media.createDataMount(disk, serverLevel)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void detachIfAttached() {
        if (this.computer != null) {
            this.computer.unmount("optical");
            this.computer = null;
        }
    }

    public void detach(@NotNull IComputerAccess computer) {
        if (this.computer != null) {
            this.computer.unmount("optical");
        }
        this.computer = null;
    }

    public boolean equals(@Nullable IPeripheral other) {
        return false;
    }
}

