/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.peripheral;

import com.mc3699.codmod.block.teleporter.TeleporterBlockEntity;
import com.mc3699.codmod.registry.CodComponents;
import com.mc3699.codmod.registry.CodItems;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class TeleporterPeripheral
implements IPeripheral {
    private final TeleporterBlockEntity blockEntity;

    public TeleporterPeripheral(TeleporterBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public String getType() {
        return "teleporter";
    }

    @LuaFunction
    public final void teleport(int x, int y, int z) {
        Level level = this.blockEntity.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AABB teleportArea = new AABB(this.blockEntity.getBlockPos().above());
            List entities = serverLevel.getEntities((Entity)null, teleportArea, entity -> true);
            entities.forEach(entity -> {
                if (entity instanceof ItemEntity) {
                    ItemEntity item = (ItemEntity)entity;
                    if (item.getItem().is(Items.BREAD)) {
                        ItemEntity teleportedBread = new ItemEntity((Level)serverLevel, (double)x + 0.5, (double)y, (double)z + 0.5, CodItems.TELEPORTED_BREAD.asStack(item.getItem().getCount()));
                        item.discard();
                        serverLevel.addFreshEntity((Entity)teleportedBread);
                    } else {
                        entity.teleportTo((double)x + 0.5, (double)y, (double)z + 0.5);
                    }
                } else {
                    entity.teleportTo((double)x + 0.5, (double)y, (double)z + 0.5);
                }
            });
            serverLevel.playSound(null, this.blockEntity.getBlockPos(), SoundEvents.BEACON_ACTIVATE, SoundSource.MASTER);
            serverLevel.playSound(null, new BlockPos(x, y, z), SoundEvents.PLAYER_TELEPORT, SoundSource.MASTER);
            Vec3 particlePos = this.blockEntity.getBlockPos().above().getBottomCenter();
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, (double)x + 0.5, (double)y, (double)z + 0.5, 50, 0.0, 0.5, 0.0, 0.1);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, particlePos.x, particlePos.y, particlePos.z, 50, 0.0, 0.5, 0.0, 0.1);
        }
    }

    @LuaFunction
    public final void pull(String id) {
        Level level = this.blockEntity.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List playerList = serverLevel.getServer().getPlayerList().getPlayers();
            for (ServerPlayer player : playerList) {
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack stack = player.getInventory().getItem(i);
                    String transponderID = (String)stack.get(CodComponents.TRANSPONDER_ID);
                    if (transponderID == null || !transponderID.equals(id)) continue;
                    Vec3 teleportPos = this.blockEntity.getBlockPos().above().getBottomCenter();
                    Vec3 playerPos = player.getPosition(0.0f);
                    serverLevel.playSound(null, player.getBlockPosBelowThatAffectsMyMovement(), SoundEvents.PLAYER_TELEPORT, SoundSource.MASTER);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, playerPos.x, playerPos.y + 1.0, playerPos.z, 100, 0.0, 0.5, 0.0, 0.05);
                    player.teleportTo(serverLevel, teleportPos.x(), teleportPos.y(), teleportPos.z(), RelativeMovement.ALL, player.getYRot(), player.getXRot());
                    serverLevel.playSound(null, player.getBlockPosBelowThatAffectsMyMovement(), SoundEvents.PLAYER_TELEPORT, SoundSource.MASTER);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, teleportPos.x, teleportPos.y, teleportPos.z, 50, 0.0, 0.5, 0.0, 0.1);
                }
            }
        }
    }

    public boolean equals(@Nullable IPeripheral other) {
        return false;
    }
}

