/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.oxygenDistributor;

import com.mc3699.codmod.block.oxygenDistributor.OxygenDistributorBlockEntity;
import com.mc3699.codmod.registry.CodBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class OxygenDistributorBlock
extends Block
implements EntityBlock {
    public OxygenDistributorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new OxygenDistributorBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == CodBlockEntities.OXYGEN_DISTRIBUTOR.get() ? OxygenDistributorBlockEntity::tick : null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = serverLevel.getBlockEntity(pos);
            if (blockEntity instanceof OxygenDistributorBlockEntity) {
                OxygenDistributorBlockEntity distributorBlockEntity;
                boolean renderState = (distributorBlockEntity = (OxygenDistributorBlockEntity)blockEntity).shouldRender();
                distributorBlockEntity.setShouldRender(!renderState);
                serverLevel.playSound(null, pos, SoundEvents.WOODEN_BUTTON_CLICK_ON, SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

