/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.client;

import com.mc3699.codmod.client.ClientOxygen;
import com.mc3699.codmod.datagen.DatagenItemTagProvider;
import com.mc3699.codmod.item.OxygenTankItem;
import com.mc3699.codmod.registry.CodItems;
import com.mc3699.codmod.registry.CodMobEffects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="codmod", value={Dist.CLIENT})
public class ClientGUIEvents {
    private static final ResourceLocation CORRUPTED_HEART = ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/gui/corrupt_full.png");
    private static final ResourceLocation VANILLA_HEART = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/sprites/hud/heart/full.png");
    private static final Random random = new Random();
    public static final ResourceLocation OXYGEN_FULL = ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/gui/oxygen_full.png");
    public static final ResourceLocation OXYGEN_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/gui/oxygen_empty.png");
    public static final ResourceLocation OXYGEN_SAT_FULL = ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/gui/oxygen_saturation_full.png");
    public static final ResourceLocation OXYGEN_SAT_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/gui/oxygen_saturation_empty.png");
    public static final ResourceLocation WARNING = ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/gui/warning.png");

    @SubscribeEvent
    public static void onRenderGUI(RenderGuiLayerEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (event.getName().equals((Object)VanillaGuiLayers.PLAYER_HEALTH) && player != null && player.hasEffect(CodMobEffects.HEART_CORRUPTION)) {
            event.setCanceled(true);
            ClientGUIEvents.renderCorruptHearts(event.getGuiGraphics(), (Player)player);
        }
        if (player != null && player.getInventory().getArmor(3).is(CodItems.SPACE_HELMET)) {
            ClientGUIEvents.renderSpaceSuit(event.getGuiGraphics(), (Player)player);
        }
    }

    private static void renderCorruptHearts(GuiGraphics guiGraphics, Player player) {
        int randY;
        int randX;
        int i;
        int maxHealth = (int)player.getMaxHealth();
        int health = (int)player.getHealth();
        int corruptedHearts = (20 - maxHealth) / 2;
        int x = guiGraphics.guiWidth() / 2 - 91;
        int y = guiGraphics.guiHeight() - 39;
        for (i = 0; i < corruptedHearts; ++i) {
            randX = random.nextInt(-5, 5);
            randY = random.nextInt(-5, 5);
            guiGraphics.blit(CORRUPTED_HEART, x + i * 8 + randX, y + randY, 0.0f, 0.0f, 9, 9, 9, 9);
        }
        for (i = corruptedHearts; i < health / 2; ++i) {
            randX = random.nextInt(-5, 5);
            randY = random.nextInt(-5, 5);
            guiGraphics.blitSprite(VANILLA_HEART, x + i * 8 + randX, y + randY, 9, 9);
        }
    }

    private static void renderSpaceSuit(GuiGraphics guiGraphics, Player player) {
        boolean suitValid = true;
        for (ItemStack stack : player.getArmorSlots()) {
            if (stack.is(DatagenItemTagProvider.SPACE_SUIT_VALID)) continue;
            suitValid = false;
        }
        if (!suitValid && System.currentTimeMillis() % 1000L < 500L) {
            guiGraphics.blit(WARNING, guiGraphics.guiWidth() / 2 - 8, guiGraphics.guiHeight() / 2 - 40, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.drawCenteredString(Minecraft.getInstance().font, "MASTER CAUTION", guiGraphics.guiWidth() / 2, guiGraphics.guiHeight() / 2 - 20, 0xFF0000);
        }
        if (ClientOxygen.oxygenSaturation < 100 && System.currentTimeMillis() % 500L < 250L) {
            guiGraphics.blit(WARNING, guiGraphics.guiWidth() / 2 - 8, guiGraphics.guiHeight() / 2 - 70, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.drawCenteredString(Minecraft.getInstance().font, "OXYGEN SATURATION LOW", guiGraphics.guiWidth() / 2, guiGraphics.guiHeight() / 2 - 50, 0xFF0000);
        }
        int oxygenCapacity = 0;
        int storedOxygen = 0;
        for (ItemStack stack : player.getInventory().items) {
            Item item = stack.getItem();
            if (!(item instanceof OxygenTankItem)) continue;
            OxygenTankItem tank = (OxygenTankItem)item;
            oxygenCapacity += 1000;
            storedOxygen += tank.getOxygen(stack);
        }
        guiGraphics.blit(OXYGEN_EMPTY, 5, 5, 0.0f, 0.0f, 128, 8, 128, 8);
        int totalOxygen = (int)Math.ceil((double)storedOxygen / (double)oxygenCapacity * 128.0);
        guiGraphics.blit(OXYGEN_FULL, 5, 5, 0.0f, 0.0f, totalOxygen, 8, 128, 8);
        guiGraphics.blit(OXYGEN_SAT_EMPTY, 5, 15, 0.0f, 0.0f, 128, 8, 128, 8);
        int oxygenFilled = (int)Math.ceil((double)ClientOxygen.oxygenSaturation / 300.0 * 128.0);
        guiGraphics.blit(OXYGEN_SAT_FULL, 5, 15, 0.0f, 0.0f, oxygenFilled, 8, 128, 8);
    }
}

