/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.consoles;

import com.mc3699.codmod.consoles.ConsoleData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ConsoleManager {
    private static final Map<UUID, ConsoleData> CONSOLE_DATA = new HashMap<UUID, ConsoleData>();

    public static CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<UUID, ConsoleData> entry : CONSOLE_DATA.entrySet()) {
            tag.put(entry.getKey().toString(), (Tag)entry.getValue().serialize());
        }
        return tag;
    }

    public static void deserialize(CompoundTag tag) {
        CONSOLE_DATA.clear();
        for (String key : tag.getAllKeys()) {
            ConsoleData data = new ConsoleData();
            data.deserialize(tag.getCompound(key));
            CONSOLE_DATA.put(UUID.fromString(key), data);
        }
    }

    public static ConsoleData getConsoleData(UUID uuid) {
        return CONSOLE_DATA.computeIfAbsent(uuid, u -> new ConsoleData());
    }
}

