/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.cod_almighty;

import com.mc3699.codmod.client.EntityAnimations;
import com.mc3699.codmod.entity.cod_almighty.CodAlmightyEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class CodAlmightyModel<T extends CodAlmightyEntity>
extends HierarchicalModel<CodAlmightyEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"cod_almighty"), "main");
    private ModelPart root;
    private ModelPart body;
    private ModelPart head;
    private ModelPart leftFin;
    private ModelPart rightFin;
    private ModelPart tailfin;
    private ModelPart waist;
    private ModelPart halo;

    public CodAlmightyModel(ModelPart root) {
        this.root = root.getChild("root");
        this.body = this.root.getChild("body");
        this.head = this.body.getChild("head");
        this.leftFin = this.body.getChild("leftFin");
        this.rightFin = this.body.getChild("rightFin");
        this.tailfin = this.body.getChild("tailfin");
        this.waist = this.body.getChild("waist");
        this.halo = this.body.getChild("halo");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -4.0f, 1.0f, 2.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(20, -6).addBox(0.0f, -5.0f, 0.0f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(22, -1).addBox(0.0f, 0.0f, 3.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-4.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-0.9992f, -2.0008f, -3.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(11, 0).addBox(-1.0f, -2.0f, -2.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition leftFin = body.addOrReplaceChild("leftFin", CubeListBuilder.create().texOffs(24, 4).addBox(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition rightFin = body.addOrReplaceChild("rightFin", CubeListBuilder.create().texOffs(24, 1).addBox(-2.0f, 0.0f, 0.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition tailfin = body.addOrReplaceChild("tailfin", CubeListBuilder.create().texOffs(20, 1).addBox(0.0f, -4.0f, 0.0f, 0.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)8.0f));
        PartDefinition waist = body.addOrReplaceChild("waist", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition halo = body.addOrReplaceChild("halo", CubeListBuilder.create().texOffs(0, 11).addBox(-4.0f, -0.5f, -4.0f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.5f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(CodAlmightyEntity codAlmightyEntity, float v, float v1, float v2, float v3, float v4) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (!codAlmightyEntity.shootAnim.isStarted()) {
            this.animate(codAlmightyEntity.idleAnim, EntityAnimations.CA_LEVITATE, v2);
        } else {
            this.animate(codAlmightyEntity.shootAnim, EntityAnimations.CA_LEVITATE, v2);
        }
    }
}

