/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.swarmCod;

import com.mc3699.codmod.entity.swarmCod.SwarmCodEntity;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.Vec3;

public class SwarmCodMoveControl
extends MoveControl {
    private final Random random = new Random();
    private float yRot = 0.0f;
    private int jumpDelay = 0;

    public SwarmCodMoveControl(Mob mob) {
        super(mob);
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            if (this.mob.onGround() && --this.jumpDelay <= 0) {
                LivingEntity livingEntity;
                Mob mob = this.mob;
                if (mob instanceof SwarmCodEntity) {
                    SwarmCodEntity swarmCod = (SwarmCodEntity)mob;
                    livingEntity = swarmCod.getTarget();
                } else {
                    livingEntity = null;
                }
                LivingEntity target = livingEntity;
                double dx = this.wantedX - this.mob.getX();
                double dz = this.wantedZ - this.mob.getZ();
                float newYRot = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
                this.mob.setYRot(this.rotlerp(this.mob.getYRot(), newYRot, 90.0f));
                this.yRot = this.mob.getYRot();
                Vec3 motion = this.mob.getDeltaMovement();
                if (motion.x != 0.0 || motion.z != 0.0) {
                    float targetYaw = (float)(Mth.atan2((double)motion.z, (double)motion.x) * 57.29577951308232) - 90.0f;
                    this.mob.setYRot(this.mob.getYRot() + Mth.wrapDegrees((float)(targetYaw - this.mob.getYRot())) * 0.5f);
                }
                Vec3 dir = ((SwarmCodEntity)this.mob).getMovementDirectionToEntity(target, 0.8 + (double)this.random.nextFloat(-1.0f, 1.0f));
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(dir.x, 0.6, dir.z));
                this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.COD_FLOP, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.jumpDelay = this.mob.getRandom().nextInt(10) + 1;
                if (this.random.nextInt(1, 10) > 9) {
                    this.mob.level().addFreshEntity((Entity)new SwarmCodEntity(null, this.mob.level()));
                }
            }
        } else {
            this.mob.setSpeed(0.0f);
        }
    }

    public void setWantedMovement(float yRot, double speed) {
        this.yRot = yRot;
        this.operation = MoveControl.Operation.MOVE_TO;
    }
}

