/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.vay;

import com.mc3699.codmod.registry.CodBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VayEntity
extends PathfinderMob {
    private boolean triggered = false;
    private Player triggerPlayer;
    private int lookTimer = 10;

    public VayEntity(EntityType<VayEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    private boolean isPlayerLookingAt(Player player, Entity target) {
        Vec3 eyePos = player.getEyePosition();
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 targetPos = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
        double distance = eyePos.distanceTo(targetPos);
        if (distance > 200.0) {
            return false;
        }
        Vec3 scaledLook = lookVec.scale(distance);
        Vec3 lookEnd = eyePos.add(scaledLook);
        AABB entityBB = target.getBoundingBox();
        return entityBB.contains(lookEnd) || entityBB.clip(eyePos, lookEnd).isPresent();
    }

    private void facePlayer(Player player) {
        Vec3 entityPos = this.position();
        Vec3 playerPos = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
        double dX = playerPos.x - entityPos.x;
        double dZ = playerPos.z - entityPos.z;
        float targetYaw = (float)(Mth.atan2((double)dZ, (double)dX) * 57.29577951308232) - 90.0f;
        this.setYRot(targetYaw);
        this.yHeadRot = targetYaw;
        this.yBodyRot = targetYaw;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
        super.registerGoals();
    }

    public void spreadBlock(ServerLevel level, BlockPos pos, int radius, float chance, Block spreadBlock) {
        for (BlockPos targetPos : BlockPos.betweenClosed((BlockPos)pos.offset(-radius, -radius, -radius), (BlockPos)pos.offset(radius, radius, radius))) {
            BlockState targetState;
            int distance = Math.abs(targetPos.getX() - pos.getX()) + Math.abs(targetPos.getY() - pos.getY()) + Math.abs(targetPos.getZ() - pos.getZ());
            if (distance != radius || !(this.random.nextFloat() < chance) || !(targetState = level.getBlockState(targetPos)).is(BlockTags.SCULK_REPLACEABLE)) continue;
            level.setBlock(targetPos, spreadBlock.defaultBlockState(), 3);
        }
    }

    public void onRemovedFromLevel() {
        if (this.triggerPlayer != null) {
            this.triggerPlayer.sendSystemMessage((Component)Component.translatable((String)"chat.codmod.vay_leave").setStyle(Style.EMPTY.withColor(0xFFFF55)));
        }
        super.onRemovedFromLevel();
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.isAggressive() && !this.triggered) {
                for (Player player : serverLevel.players()) {
                    if (!this.isPlayerLookingAt(player, (Entity)this)) continue;
                    if (this.tickCount % 2 == 0) {
                        for (int i = 0; i < 5; ++i) {
                            this.spreadBlock(serverLevel, this.getOnPos(), i, 0.3f, Blocks.COPPER_BLOCK);
                            this.spreadBlock(serverLevel, this.getOnPos(), i, 0.1f, Blocks.WEATHERED_COPPER);
                            this.spreadBlock(serverLevel, this.getOnPos(), i, 0.3f, Blocks.OXIDIZED_COPPER);
                            this.spreadBlock(serverLevel, this.getOnPos(), i, 0.6f, (Block)CodBlocks.MOLTEN_COPPER.get());
                            this.spreadBlock(serverLevel, this.getOnPos(), i, 0.9f, (Block)CodBlocks.MOLTEN_COPPER.get());
                        }
                    }
                    --this.lookTimer;
                    if (this.lookTimer >= 1) continue;
                    this.triggered = true;
                    this.triggerPlayer = player;
                    this.facePlayer(this.triggerPlayer);
                    this.setTarget((LivingEntity)this.triggerPlayer);
                    this.setAggressive(true);
                }
            }
        }
    }
}

