/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.mixin;

import com.mc3699.codmod.client.EntropyEvents;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class EntropyMixin {
    @Shadow
    @Nullable
    private ClientLevel level;

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")}, cancellable=true)
    private void stopRendering(PoseStack poseStack, Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        if (this.level != null && this.level.dimension() == EntropyEvents.ENTROPY_KEY) {
            ci.cancel();
        }
    }

    @Inject(method={"renderSky"}, at={@At(value="HEAD")}, cancellable=true)
    private void noSky(Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        if (this.level != null && this.level.dimension() == EntropyEvents.ENTROPY_KEY) {
            PoseStack poseStack = new PoseStack();
            poseStack.mulPose(frustumMatrix);
            Tesselator tesselator = Tesselator.getInstance();
            float celestialAngle = this.level.getTimeOfDay(partialTick) * 360.0f;
            poseStack.mulPose(Axis.ZP.rotationDegrees(celestialAngle));
            float f12 = 80.0f;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/environment/blue_sun.png"));
            BufferBuilder bufferbuilder1 = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            Matrix4f matrix4f = poseStack.last().pose();
            bufferbuilder1.addVertex(matrix4f, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
            bufferbuilder1.addVertex(matrix4f, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
            bufferbuilder1.addVertex(matrix4f, f12, 100.0f, f12).setUv(1.0f, 1.0f);
            bufferbuilder1.addVertex(matrix4f, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder1.buildOrThrow());
            ci.cancel();
        }
    }
}

