/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.consoles;

import com.mc3699.codmod.consoles.ConsoleData;
import com.mc3699.codmod.consoles.ConsoleManager;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public abstract class BaseConsoleBlockEntity
extends BlockEntity {
    @Nullable
    protected UUID uuid;

    public BaseConsoleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.uuid = tag.contains("uuid", 8) ? UUID.fromString(tag.getString("uuid")) : UUID.randomUUID();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("uuid", (this.uuid != null ? this.uuid : UUID.randomUUID()).toString());
    }

    public ConsoleData getConsoleData() {
        return ConsoleManager.getConsoleData(this.uuid);
    }
}

