/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.dimension.backrooms.levels;

import com.mc3699.codmod.dimension.backrooms.BRGenUtil;
import com.mc3699.codmod.dimension.backrooms.BackroomsLevel;
import com.mc3699.codmod.registry.CodBlocks;
import java.util.List;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;

public class Poolrooms
extends BackroomsLevel {
    public static final PerlinNoise FilledNoise = PerlinNoise.create((RandomSource)RandomSource.create(), List.of(Integer.valueOf(1), Integer.valueOf(5), Integer.valueOf(9), Integer.valueOf(9), Integer.valueOf(38), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(43)));
    public static final PerlinNoise LargeWallNoise = PerlinNoise.create((RandomSource)RandomSource.create(), List.of(Integer.valueOf(33), Integer.valueOf(1), Integer.valueOf(38), Integer.valueOf(29), Integer.valueOf(19), Integer.valueOf(21)));
    public static final PerlinNoise PlatformNoise = PerlinNoise.create((RandomSource)RandomSource.create(), List.of(Integer.valueOf(32), Integer.valueOf(69), Integer.valueOf(420), Integer.valueOf(69), Integer.valueOf(69), Integer.valueOf(128), Integer.valueOf(69), Integer.valueOf(420)));

    @Override
    public int getStartLevel() {
        return 10;
    }

    @Override
    public int getEndLevel() {
        return 22;
    }

    @Override
    public void generate(WorldGenRegion worldGenRegion, StructureManager structureManager, RandomState randomState, ChunkAccess chunkAccess) {
        BRGenUtil.fillLayer(chunkAccess, this.getStartLevel(), ((Block)CodBlocks.CERAMIC_TILE.get()).defaultBlockState());
        BRGenUtil.fillLayer(chunkAccess, this.getStartLevel() + 3, (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(15)));
        BRGenUtil.fillLayer(chunkAccess, this.getEndLevel() - 3, (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(15)));
        BRGenUtil.fillLayer(chunkAccess, this.getStartLevel() + 1, Blocks.WATER.defaultBlockState());
        BRGenUtil.fillLayer(chunkAccess, this.getEndLevel(), CodBlocks.CERAMIC_TILE.getDefaultState());
        if (BRGenUtil.isChunkInNoise(chunkAccess, FilledNoise, 0.05)) {
            BRGenUtil.fillArea(chunkAccess, 0, this.getStartLevel(), 0, 15, this.getEndLevel(), 15, CodBlocks.CERAMIC_TILE.getDefaultState());
        } else if (BRGenUtil.isChunkInNoise(chunkAccess, LargeWallNoise, 0.06)) {
            BRGenUtil.generateBasicWalls(chunkAccess, this.getStartLevel(), this.getEndLevel(), CodBlocks.CERAMIC_TILE.getDefaultState());
        }
        if (BRGenUtil.isChunkInNoise(chunkAccess, PlatformNoise, 0.02)) {
            // empty if block
        }
    }
}

