/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity;

import com.mc3699.codmod.entity.itemProjectile.ItemProjectileEntity;
import com.mc3699.codmod.registry.CodSounds;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MarksmanRevolverCoinEntity
extends ItemProjectileEntity {
    private static final EntityDataAccessor<Integer> RICO_COUNT = SynchedEntityData.defineId(MarksmanRevolverCoinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public MarksmanRevolverCoinEntity(EntityType<? extends ItemProjectileEntity> entityType, Level level) {
        super(entityType, level, new ItemStack((ItemLike)Items.COD, 1), 0, 0, false);
    }

    public void hit(Player player) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LivingEntity nearest = this.getNearest(serverLevel, player);
            if (nearest != null) {
                MarksmanRevolverCoinEntity.spawnParticleLine(serverLevel, this.position(), nearest.getEyePosition(), (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, 100);
                nearest.hurt(serverLevel.damageSources().playerAttack(player), 20.0f);
            }
            this.discard();
        }
    }

    public static void spawnParticleLine(ServerLevel level, Vec3 from, Vec3 to, ParticleOptions particle, int steps) {
        Vec3 delta = to.subtract(from);
        for (int i = 0; i <= steps; ++i) {
            double t = (double)i / (double)steps;
            Vec3 point = from.add(delta.scale(t));
            level.sendParticles(particle, point.x, point.y, point.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(RICO_COUNT, (Object)0);
        super.defineSynchedData(builder);
    }

    private LivingEntity getNearest(ServerLevel serverLevel, Player firingEntity) {
        AABB searchArea = new AABB(this.blockPosition()).inflate(16.0);
        List nearTargets = serverLevel.getEntities((Entity)this, searchArea, entity -> !entity.is((Entity)firingEntity) && entity.isAlive());
        LivingEntity nearest = null;
        double closestDist = Double.MAX_VALUE;
        for (Entity target : nearTargets) {
            double dist;
            if (target instanceof MarksmanRevolverCoinEntity) {
                MarksmanRevolverCoinEntity coinEntity = (MarksmanRevolverCoinEntity)target;
                int nextRicoCount = (Integer)coinEntity.getEntityData().get(RICO_COUNT);
                int ricoCount = (Integer)this.getEntityData().get(RICO_COUNT);
                if (nextRicoCount == 0) {
                    coinEntity.getEntityData().set(RICO_COUNT, (Object)1);
                    MarksmanRevolverCoinEntity.spawnParticleLine(serverLevel, this.position(), coinEntity.getPosition(0.0f), (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, 100);
                    coinEntity.hit(firingEntity);
                    serverLevel.playSound(null, this.blockPosition(), (SoundEvent)CodSounds.COIN.value(), SoundSource.MASTER, 2.0f, 1.0f);
                }
            }
            if (!(target instanceof LivingEntity)) continue;
            LivingEntity livingTarget = (LivingEntity)target;
            BlockHitResult result = serverLevel.clip(new ClipContext(this.position(), target.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (result.getType() != HitResult.Type.MISS || !((dist = this.position().distanceTo(target.getEyePosition())) < closestDist)) continue;
            closestDist = dist;
            nearest = livingTarget;
        }
        return nearest;
    }
}

