/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.darkener;

import com.mc3699.codmod.entity.darkener.DarkenerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class DarkenerEntityRenderer
extends LivingEntityRenderer<DarkenerEntity, PlayerModel<DarkenerEntity>> {
    Random random = new Random();

    public DarkenerEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false), 0.25f);
    }

    public ResourceLocation getTextureLocation(DarkenerEntity darkenerEntity) {
        return ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/entity/darkener.png");
    }

    protected boolean shouldShowName(DarkenerEntity entity) {
        return false;
    }

    public void render(DarkenerEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity.tickCount % 5 == 0) {
            poseStack.pushPose();
            float glitchBounds = 0.25f;
            float randX = this.random.nextFloat(-glitchBounds, glitchBounds);
            float randY = this.random.nextFloat(-glitchBounds, glitchBounds);
            float randZ = this.random.nextFloat(-glitchBounds, glitchBounds);
            poseStack.translate(randX, randY, randZ);
            super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
            poseStack.popPose();
        } else {
            super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }
}

