/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.uav;

import com.mc3699.codmod.entity.uav.UAVEntity;
import com.mc3699.codmod.registry.CodItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class UAVEntityRenderer
extends EntityRenderer<UAVEntity> {
    private final ItemRenderer itemRenderer;

    public UAVEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public boolean shouldRender(UAVEntity livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public void render(UAVEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        ItemStack stackItem = new ItemStack((ItemLike)CodItems.UAV.get());
        poseStack.pushPose();
        poseStack.scale(3.0f, 3.0f, 3.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(entity.getYRot() * -1.0f - 90.0f));
        BakedModel model = this.itemRenderer.getModel(stackItem, entity.level(), null, 0);
        this.itemRenderer.render(stackItem, ItemDisplayContext.GROUND, false, poseStack, bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(UAVEntity uavEntity) {
        return ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/item/uav.png");
    }
}

