/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.wisp;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.level.Level;

public abstract class BaseWispEntity
extends PathfinderMob {
    private final List<ParticleType<?>> particleTypes;
    private int color;

    protected BaseWispEntity(EntityType<? extends PathfinderMob> type, Level level, int color, List<ParticleType<?>> particleTypes) {
        super(type, level);
        this.color = color;
        this.particleTypes = particleTypes;
    }

    public int getColor() {
        return this.color;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            // empty if block
        }
    }

    private void spawnParticles() {
        double speed = 0.4;
        double dx = (this.random.nextDouble() - 0.5) * speed;
        double dy = (this.random.nextDouble() - 0.5) * speed;
        double dz = (this.random.nextDouble() - 0.5) * speed;
        int randParticle = this.random.nextInt(0, this.particleTypes.size());
        this.level().addParticle((ParticleOptions)this.particleTypes.get(randParticle), this.getX(), this.getY() + 2.5, this.getZ(), dx, dy, dz);
    }

    public boolean save(CompoundTag compound) {
        compound.putInt("color", this.color);
        return super.save(compound);
    }

    public void load(CompoundTag compound) {
        this.color = compound.getInt("color");
        super.load(compound);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new OpenDoorGoal((Mob)this, false));
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, (double)0.3f));
    }
}

