/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.event;

import com.mc3699.codmod.registry.CodEntities;
import dev.wendigodrip.thebrokenscript.api.event.BaseEvent;
import dev.wendigodrip.thebrokenscript.api.ext.EntityTypeExt;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class FireLightEvent
extends BaseEvent {
    public FireLightEvent() {
        super(1);
    }

    private void spawnFireLight(ServerPlayer player, ServerLevel serverLevel, int radius) {
        RandomSource random = serverLevel.random;
        double angle = random.nextDouble() * 2.0 * Math.PI;
        double distance = random.nextDouble() * (double)radius;
        double x = player.getX() + Math.cos(angle) * distance;
        double z = player.getZ() + Math.sin(angle) * distance;
        double y = player.getY();
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        while (!serverLevel.getBlockState(pos.below()).isSolid() && pos.getY() > serverLevel.getMinBuildHeight()) {
            pos = pos.below();
        }
        while (serverLevel.getBlockState(pos).isSolid() && pos.getY() < serverLevel.getMaxBuildHeight()) {
            pos = pos.above();
        }
        EntityTypeExt.INSTANCE.trySummon((EntityType)CodEntities.FIRELIGHT.get(), (LevelAccessor)serverLevel, pos.getCenter().add(0.5, 0.0, 0.5));
    }

    public void execute(ServerLevel level, ServerPlayer player, Vec3 vec3) {
        level.players().forEach(victim -> {
            RandomSource random = level.random;
            if (random.nextInt(0, 10) > 2) {
                this.spawnFireLight((ServerPlayer)victim, level, 50);
            }
        });
    }
}

