/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.event;

import com.mc3699.codmod.block.johnGeometry.JohnGeometryBlock;
import com.mc3699.codmod.registry.CodBlocks;
import dev.wendigodrip.thebrokenscript.api.event.BaseEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class JohnGeometryEvent
extends BaseEvent {
    public JohnGeometryEvent() {
        super(1);
    }

    public static void placeJohn(ServerLevel level, BlockPos pos, int radius) {
        BlockPos closestDoor = null;
        double minDistance = Double.MAX_VALUE;
        for (BlockPos checkPos : BlockPos.betweenClosed((BlockPos)pos.offset(-radius, -radius, -radius), (BlockPos)pos.offset(radius, radius, radius))) {
            double distance;
            BlockState state = level.getBlockState(checkPos);
            if (!(state.getBlock() instanceof DoorBlock) || state.getValue((Property)DoorBlock.HALF) != DoubleBlockHalf.LOWER || !((distance = pos.distSqr((Vec3i)checkPos)) < minDistance)) continue;
            minDistance = distance;
            closestDoor = checkPos.immutable();
        }
        if (closestDoor != null) {
            BlockState doorState = level.getBlockState(closestDoor);
            Direction facing = (Direction)doorState.getValue((Property)DoorBlock.FACING);
            DoorHingeSide hinge = (DoorHingeSide)doorState.getValue((Property)DoorBlock.HINGE);
            boolean open = (Boolean)doorState.getValue((Property)DoorBlock.OPEN);
            BlockPos placePos = closestDoor.relative(facing, open ? (hinge == DoorHingeSide.LEFT ? 2 : -2) : -2);
            level.setBlock(placePos, (BlockState)((Block)CodBlocks.JOHN_GEOMETRY.get()).defaultBlockState().setValue((Property)JohnGeometryBlock.FACING, (Comparable)facing), 3);
        }
    }

    protected void execute(@NotNull ServerLevel serverLevel, @NotNull ServerPlayer serverPlayer, @NotNull Vec3 vec3) {
        serverLevel.players().forEach(victim -> {
            if (serverLevel.random.nextInt(1, 10) > 0) {
                JohnGeometryEvent.placeJohn(serverLevel, victim.getBlockPosBelowThatAffectsMyMovement(), 30);
            }
        });
    }
}

