/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.event;

import com.mc3699.codmod.item.BelowEternityItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="codmod")
public class WardenEventHandler {
    @SubscribeEvent
    public static void onWardenTargeting(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Warden)) {
            return;
        }
        Warden warden = (Warden)livingEntity;
        boolean hasNearbyWandHolder = warden.level().getEntitiesOfClass(Player.class, warden.getBoundingBox().inflate(16.0)).stream().anyMatch(WardenEventHandler::hasActiveBelowEternity);
        if (hasNearbyWandHolder) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWardenTick(EntityTickEvent.Post event) {
        long peacefulUntil;
        Player holder;
        Entity entity = event.getEntity();
        if (!(entity instanceof Warden)) {
            return;
        }
        Warden warden = (Warden)entity;
        if (warden.getPersistentData().getBoolean("IsFriendly")) {
            return;
        }
        if (warden.tickCount % 20 == 0 && (holder = (Player)warden.level().getEntitiesOfClass(Player.class, warden.getBoundingBox().inflate(16.0)).stream().filter(WardenEventHandler::hasActiveBelowEternity).findFirst().orElse(null)) != null) {
            if (warden.getTarget() == holder) {
                warden.setTarget(null);
                warden.getNavigation().stop();
            }
            try {
                warden.clearAnger((Entity)holder);
            }
            catch (Exception exception) {
                // empty catch block
            }
            warden.getPersistentData().putLong("PeacefulUntil", warden.level().getGameTime() + 100L);
        }
        if ((peacefulUntil = warden.getPersistentData().getLong("PeacefulUntil")) > 0L && warden.level().getGameTime() > peacefulUntil) {
            warden.getPersistentData().remove("PeacefulUntil");
        }
    }

    private static boolean hasActiveBelowEternity(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        if (mainHand.getItem() instanceof BelowEternityItem) {
            return true;
        }
        ItemStack offHand = player.getOffhandItem();
        if (offHand.getItem() instanceof BelowEternityItem) {
            return true;
        }
        return player.getInventory().items.stream().anyMatch(stack -> stack.getItem() instanceof BelowEternityItem);
    }

    @SubscribeEvent
    public static void onWardenDrops(LivingDropsEvent event) {
        Warden warden;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Warden && (warden = (Warden)livingEntity).getPersistentData().getBoolean("NoDrops")) {
            event.getDrops().clear();
        }
    }

    @SubscribeEvent
    public static void onWardenXP(LivingExperienceDropEvent event) {
        Warden warden;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Warden && (warden = (Warden)livingEntity).getPersistentData().getBoolean("NoDrops")) {
            event.setCanceled(true);
        }
    }
}

