/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.handlers;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@EventBusSubscriber(modid="codmod", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class BadSunClientEvents {
    private static boolean isBadSunDay = false;

    public static void setBadSunDay(boolean badSunDay) {
        isBadSunDay = badSunDay;
    }

    public static Vec3 getSunDirection(Level level, float partialTicks) {
        float sunAngle = level.getSunAngle(partialTicks);
        double x = -Math.sin(sunAngle);
        double y = Math.cos(sunAngle);
        double z = 0.0;
        return new Vec3(x, y, z).normalize();
    }

    @SubscribeEvent
    public static void sunBlackBoxRender(RenderGuiLayerEvent.Post event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level != null) {
            Vec3 sunPos = BadSunClientEvents.getSunDirection((Level)minecraft.level, 0.0f).scale(1000.0);
            boolean canSeeSun = minecraft.level.clip(new ClipContext(minecraft.player.position().add(new Vec3(0.0, (double)1.62f, 0.0)), sunPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)minecraft.player)).getType() == HitResult.Type.MISS;
            Vec3 sunDir = BadSunClientEvents.getSunDirection((Level)minecraft.level, minecraft.getFrameTimeNs());
            Vec2 sunScreen = BadSunClientEvents.projectDirectionToScreen(sunDir, minecraft);
            if (sunScreen == null || !canSeeSun || !isBadSunDay) {
                return;
            }
            GuiGraphics graphics = event.getGuiGraphics();
            int size = 48;
            int x1 = Mth.floor((float)(sunScreen.x - (float)size));
            int y1 = Mth.floor((float)(sunScreen.y - (float)size));
            int x2 = Mth.floor((float)(sunScreen.x + (float)size));
            int y2 = Mth.floor((float)(sunScreen.y + (float)size));
            graphics.fill(x1, y1, x2, y2, -16777216);
        }
    }

    public static Vec2 projectDirectionToScreen(Vec3 dirWorld, Minecraft mc) {
        Camera cam = mc.gameRenderer.getMainCamera();
        Quaternionf inverseCamRot = new Quaternionf((Quaternionfc)cam.rotation()).conjugate();
        Vector3f dirCamera = new Vector3f((float)dirWorld.x, (float)dirWorld.y, (float)dirWorld.z).normalize().rotate((Quaternionfc)inverseCamRot);
        if (dirCamera.z >= 0.0f) {
            return null;
        }
        float fovRad = (float)Math.toRadians((float)((Integer)mc.options.fov().get()).intValue() * mc.player.getFieldOfViewModifier());
        float aspect = (float)mc.getWindow().getWidth() / (float)mc.getWindow().getHeight();
        float tanHalfFov = (float)Math.tan(fovRad / 2.0f);
        float ndcX = dirCamera.x / -dirCamera.z / (tanHalfFov * aspect);
        float ndcY = dirCamera.y / -dirCamera.z / tanHalfFov;
        float screenX = (ndcX * 0.5f + 0.5f) * (float)mc.getWindow().getGuiScaledWidth();
        float screenY = (0.5f - ndcY * 0.5f) * (float)mc.getWindow().getGuiScaledHeight();
        return new Vec2(screenX, screenY);
    }
}

