/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BelowEternityItem
extends Item {
    private static final int COOLDOWN_TICKS = 2400;
    private static final double SUMMON_RANGE = 3.0;
    private static final int DESPAWN_TICKS = 1200;
    public static final Logger LOGGER = LogManager.getLogger();
    private Warden summonedWarden = null;
    private int wardenLifetime = 0;

    public BelowEternityItem(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.EPIC).durability(64));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            if (this.summonedWarden != null && this.summonedWarden.isAlive()) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            player.getCooldowns().addCooldown((Item)this, 2400);
            Vec3 playerPos = player.position();
            BlockPos spawnPos = this.findSafeSpawnPosition(level, playerPos);
            if (spawnPos != null && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Warden warden = (Warden)EntityType.WARDEN.create(level);
                if (warden != null) {
                    warden.moveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, level.random.nextFloat() * 360.0f, 0.0f);
                    warden.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(warden.blockPosition()), MobSpawnType.COMMAND, null);
                    warden.getAttribute(Attributes.MAX_HEALTH).setBaseValue(75.0);
                    warden.setHealth(75.0f);
                    warden.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(15.0);
                    warden.setPersistenceRequired();
                    warden.getPersistentData().putBoolean("NoDrops", true);
                    serverLevel.addFreshEntity((Entity)warden);
                    serverLevel.playSound(null, spawnPos, SoundEvents.WARDEN_EMERGE, SoundSource.NEUTRAL, 1.0f, 0.8f);
                    serverLevel.playSound(null, spawnPos, SoundEvents.SCULK_CATALYST_BLOOM, SoundSource.NEUTRAL, 0.8f, 1.2f);
                    this.summonedWarden = warden;
                    this.wardenLifetime = 0;
                    return InteractionResultHolder.success((Object)itemStack);
                }
            } else {
                return InteractionResultHolder.fail((Object)itemStack);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    private BlockPos findSafeSpawnPosition(Level level, Vec3 center) {
        BlockPos centerPos = BlockPos.containing((Position)center);
        for (int attempts = 0; attempts < 20; ++attempts) {
            double angle = level.random.nextDouble() * Math.PI * 2.0;
            double distance = 2.0 + level.random.nextDouble() * 1.0;
            int x = (int)(center.x + Math.cos(angle) * distance);
            int z = (int)(center.z + Math.sin(angle) * distance);
            for (int y = centerPos.getY() + 5; y >= centerPos.getY() - 10; --y) {
                BlockPos pos = new BlockPos(x, y, z);
                BlockPos posAbove = pos.above();
                BlockPos posAbove2 = pos.above(2);
                if (level.getBlockState(pos).isAir() || !level.getBlockState(posAbove).isAir() || !level.getBlockState(posAbove2).isAir()) continue;
                return posAbove;
            }
        }
        return centerPos;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (!level.isClientSide && this.summonedWarden != null && this.summonedWarden.isAlive()) {
            ++this.wardenLifetime;
            if (this.wardenLifetime >= 1200) {
                LOGGER.debug("he gone");
                this.summonedWarden.remove(Entity.RemovalReason.DISCARDED);
                this.summonedWarden = null;
                this.wardenLifetime = 0;
            }
        }
        super.inventoryTick(stack, level, entity, slot, selected);
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }
}

