/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import dev.wendigodrip.thebrokenscript.entity.circuit.CircuitEntity;
import dev.wendigodrip.thebrokenscript.registry.TBSEntities;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class CircuitBombItem
extends SnowballItem {
    public CircuitBombItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(final Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            Snowball snowball = new Snowball(this, level, (LivingEntity)player){

                protected void onHit(HitResult result) {
                    super.onHit(result);
                    if (!this.level().isClientSide) {
                        CircuitEntity circuit = new CircuitEntity((EntityType)TBSEntities.getCIRCUIT().get(), level);
                        circuit.setPos(this.getX(), this.getY(), this.getZ());
                        this.level().addFreshEntity((Entity)circuit);
                        this.discard();
                    }
                }
            };
            snowball.setItem(stack);
            snowball.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)snowball);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResultHolder.consume((Object)stack);
    }
}

