/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import com.mc3699.codmod.registry.CodMobEffects;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;

public class DaCapoItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 0;
        }

        public float getSpeed() {
            return 0.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_WOODEN_TOOL;
        }

        public int getEnchantmentValue() {
            return 24;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of();
        }
    };

    public DaCapoItem() {
        super(TOOL_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)5.0f, (float)-1.5f)).component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).rarity(Rarity.EPIC));
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.SHARPNESS) || enchantment.is(Enchantments.SMITE) || enchantment.is(Enchantments.BANE_OF_ARTHROPODS) || enchantment.is(Enchantments.KNOCKBACK) || enchantment.is(Enchantments.FIRE_ASPECT) || enchantment.is(Enchantments.LOOTING) || enchantment.is(Enchantments.SWEEPING_EDGE) || enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.MENDING) || enchantment.is(Enchantments.VANISHING_CURSE);
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        DaCapoItem.onLivingEntityHit((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)entity);
        return retval;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        DaCapoItem.onRightClick((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (ItemStack)ar.getObject());
        return ar;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"\u00a7oA sweeping, monochrome scythe. You can hear the calling of voices in the distance. Are they singing?\n").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.literal((String)"Made by BigManRake - Fixed1 by AliveAlex - Fixed2 and ported to codmod by Eyae").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        DaCapoItem.onEntitySwing((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
        return retval;
    }

    private static void onRightClick(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
        if (entity == null) {
            return;
        }
        DaCapoItem.playSound(world, x, y, z, "codmod:orchwork", SoundSource.PLAYERS, 0.4f, 1.0f);
        for (Entity entityIterator : world.getEntities(entity, new AABB(x + 14.0, y + 14.0, z + 14.0, x - 14.0, y - 14.0, z - 14.0))) {
            LivingEntity livingEntity;
            if (!(entityIterator instanceof LivingEntity) || (livingEntity = (LivingEntity)entityIterator).level().isClientSide()) continue;
            livingEntity.addEffect(new MobEffectInstance(CodMobEffects.INSANITY, 300, 0));
        }
        DaCapoItem.spawnParticles(world, x, y, z, 200, 14.0);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getCooldowns().addCooldown(itemstack.getItem(), 650);
        }
    }

    private static void onLivingEntityHit(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        float health = livingEntity.getHealth();
        float maxHealth = livingEntity.getMaxHealth();
        if (health > 0.0f) {
            int pitch = Mth.nextInt((RandomSource)RandomSource.create(), (int)8, (int)12);
            DaCapoItem.playSound(world, x, y, z, "codmod:capohit", SoundSource.PLAYERS, 0.2f, (float)pitch / 10.0f);
        } else {
            int pitch = Mth.nextInt((RandomSource)RandomSource.create(), (int)8, (int)12);
            DaCapoItem.playSound(world, x, y, z, "codmod:capokill", SoundSource.PLAYERS, 0.2f, (float)pitch / 10.0f);
        }
        if (health <= maxHealth * 0.4f && !livingEntity.level().isClientSide()) {
            livingEntity.addEffect(new MobEffectInstance(CodMobEffects.INSANITY, 160, 0));
        }
    }

    private static void onEntitySwing(LevelAccessor world, double x, double y, double z) {
        int pitch = Mth.nextInt((RandomSource)RandomSource.create(), (int)8, (int)12);
        DaCapoItem.playSound(world, x, y, z, "codmod:caposwing", SoundSource.PLAYERS, 0.4f, (float)pitch / 10.0f);
    }

    private static void playSound(LevelAccessor world, double x, double y, double z, String soundId, SoundSource source, float volume, float pitch) {
        if (world instanceof Level) {
            Level level = (Level)world;
            BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
            if (!level.isClientSide()) {
                level.playSound(null, pos, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)soundId)), source, volume, pitch);
            } else {
                level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)soundId)), source, volume, pitch, false);
            }
        }
    }

    private static void spawnParticles(LevelAccessor world, double x, double y, double z, int amount, double radius) {
        for (int i = 0; i < amount; ++i) {
            double offsetX = Mth.nextDouble((RandomSource)RandomSource.create(), (double)-1.0, (double)1.0) * radius;
            double offsetY = Mth.nextDouble((RandomSource)RandomSource.create(), (double)-1.0, (double)1.0) * radius;
            double offsetZ = Mth.nextDouble((RandomSource)RandomSource.create(), (double)-1.0, (double)1.0) * radius;
            double velX = Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.05, (double)0.05);
            double velY = Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.05, (double)0.05);
            double velZ = Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.05, (double)0.05);
            world.addParticle((ParticleOptions)ParticleTypes.NOTE, x + offsetX, y + offsetY, z + offsetZ, velX, velY, velZ);
        }
    }
}

