/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item.detector;

import com.mc3699.codmod.registry.CodItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

@ParametersAreNonnullByDefault
public class DetectorItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final DetectorItemRenderer INSTANCE = new DetectorItemRenderer();

    public DetectorItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        if (displayContext == ItemDisplayContext.GUI) {
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.scale(0.8f, 0.8f, 0.8f);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        } else if (displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            poseStack.translate(0.325, 0.27, 0.0);
            poseStack.scale(0.25f, 0.25f, 0.25f);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        } else if (displayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            poseStack.translate(0.5, 0.1, 0.5);
            poseStack.mulPose(new Matrix4f().rotate((float)Math.toRadians(180.0), 0.0f, 1.0f, 0.0f));
            poseStack.scale(2.0f, 2.0f, 2.0f);
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        itemRenderer.renderStatic(new ItemStack((ItemLike)CodItems.BROKEN_DETECTOR.get(), 1), displayContext, packedLight, packedOverlay, poseStack, buffer, null, 0);
        poseStack.translate(-0.7, 0.92, 0.075);
        poseStack.scale(0.005f, -0.005f, 0.005f);
        poseStack.translate(0.0f, 20.0f, 0.0f);
        Font font = Minecraft.getInstance().font;
        Matrix4f matrix = poseStack.last().pose();
        Vec3 pos = Minecraft.getInstance().player.getPosition(0.0f);
        font.drawInBatch("X:" + (int)Math.ceil(pos.x), 60.0f, 0.0f, 0xFF0000, false, matrix, buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.drawInBatch("Z:" + (int)Math.ceil(pos.z), 60.0f, 10.0f, 65280, false, matrix, buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.popPose();
    }
}

