/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.johnGeometry;

import com.mc3699.codmod.registry.CodBlockEntities;
import com.mc3699.codmod.registry.CodSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class JohnGeometryBlockEntity
extends BlockEntity {
    public JohnGeometryBlockEntity(BlockPos pos, BlockState blockState) {
        super(CodBlockEntities.JOHN_GEOMETRY.get(), pos, blockState);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        AABB searchRange;
        ServerLevel serverLevel;
        List playerList;
        if (level instanceof ServerLevel && !(playerList = (serverLevel = (ServerLevel)level).getEntitiesOfClass(Player.class, searchRange = new AABB(pos).inflate(1.0))).isEmpty()) {
            serverLevel.playSound(null, pos, (SoundEvent)CodSounds.GEOMETRY.get(), SoundSource.MASTER, 1.0f, 1.0f);
            serverLevel.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            Vec3 codSpawnPos = pos.getCenter();
            for (int i = 0; i < 24; ++i) {
                Cod cod = new Cod(EntityType.COD, (Level)serverLevel);
                cod.setPos(codSpawnPos);
                int randomVelX = serverLevel.random.nextInt(-4, 4);
                int randomVelZ = serverLevel.random.nextInt(-4, 4);
                int randomHeight = serverLevel.random.nextInt(8, 24);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, codSpawnPos.x, codSpawnPos.y, codSpawnPos.z, 2, 0.0, 1.0, 0.0, (double)randomVelX);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, codSpawnPos.x, codSpawnPos.y, codSpawnPos.z, 32, 0.0, 1.0, 0.0, (double)randomVelX * 0.01);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, codSpawnPos.x, codSpawnPos.y, codSpawnPos.z, 4, 0.0, 1.0, 0.0, 0.01);
                cod.setDeltaMovement((double)randomVelX * 0.1, (double)randomHeight * 0.07, (double)randomVelZ * 0.1);
                serverLevel.addFreshEntity((Entity)cod);
            }
        }
    }
}

