/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.dimension.backrooms.levels;

import com.mc3699.codmod.dimension.backrooms.BRGenUtil;
import com.mc3699.codmod.dimension.backrooms.BackroomsLevel;
import com.mc3699.codmod.dimension.backrooms.BackroomsStructures;
import com.mc3699.codmod.registry.CodBlocks;
import java.util.List;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;

public class BackroomsLevelZero
extends BackroomsLevel {
    public static final PerlinNoise UnlitRoomNoise = PerlinNoise.create((RandomSource)RandomSource.create(), List.of(Integer.valueOf(1), Integer.valueOf(5), Integer.valueOf(9)));
    public static final PerlinNoise EmptyAreaNoise = PerlinNoise.create((RandomSource)RandomSource.create(), List.of(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(9)));
    public static final PerlinNoise RedRoomNoise = PerlinNoise.create((RandomSource)RandomSource.create(), List.of(Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(2)));
    List<BackroomsStructures.BackroomsStructureInfo> STRUCTURE_POOL = List.of(BackroomsStructures.OASIS, BackroomsStructures.PYRAMID, BackroomsStructures.OUTPOST_K84, BackroomsStructures.CARBON_ANOMALY);

    @Override
    public int getEndLevel() {
        return 9;
    }

    @Override
    public void generate(WorldGenRegion worldGenRegion, StructureManager structureManager, RandomState randomState, ChunkAccess chunkAccess) {
        BRGenUtil.fillLayer(chunkAccess, 0, Blocks.BEDROCK.defaultBlockState());
        if (BRGenUtil.isChunkInNoise(chunkAccess, RedRoomNoise, 0.3)) {
            BRGenUtil.fillLayer(chunkAccess, this.getStartLevel() + 1, ((Block)CodBlocks.RED_MOIST_CARPET.get()).defaultBlockState());
            BRGenUtil.fillLayer(chunkAccess, this.getEndLevel(), ((Block)CodBlocks.RED_CEILING_TILE.get()).defaultBlockState());
            if (!BRGenUtil.isChunkInNoise(chunkAccess, UnlitRoomNoise, 0.15)) {
                BRGenUtil.generateLights(chunkAccess, this.getEndLevel(), true);
            }
            if (!BRGenUtil.isChunkInNoise(chunkAccess, EmptyAreaNoise, 0.2)) {
                BRGenUtil.generateBasicWalls(chunkAccess, this.getStartLevel() + 1, this.getEndLevel(), ((Block)CodBlocks.RED_UGLY_WALLPAPER.get()).defaultBlockState());
            }
        } else {
            BRGenUtil.fillLayer(chunkAccess, this.getStartLevel() + 1, ((Block)CodBlocks.MOIST_CARPET.get()).defaultBlockState());
            BRGenUtil.fillLayer(chunkAccess, this.getEndLevel(), ((Block)CodBlocks.CEILING_TILE.get()).defaultBlockState());
            if (!BRGenUtil.isChunkInNoise(chunkAccess, UnlitRoomNoise, 0.15)) {
                BRGenUtil.generateLights(chunkAccess, this.getEndLevel(), false);
            }
            if (!BRGenUtil.isChunkInNoise(chunkAccess, EmptyAreaNoise, 0.2)) {
                BRGenUtil.generateBasicWalls(chunkAccess, this.getStartLevel() + 1, this.getEndLevel(), ((Block)CodBlocks.UGLY_WALLPAPER.get()).defaultBlockState());
            }
        }
        if (worldGenRegion.getRandom().nextInt(0, 300) == 1) {
            BackroomsStructures.BackroomsStructureInfo structureInfo = BRGenUtil.rollStructure(this.STRUCTURE_POOL);
            BRGenUtil.placeBackroomsStructure(structureInfo, worldGenRegion, chunkAccess.getPos().getWorldPosition().atY(this.getStartLevel() + 2), worldGenRegion.getRandom());
        }
    }
}

