/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.codmissile;

import com.mc3699.codmod.entity.codmissile.CodMissileEntity;
import com.mc3699.codmod.entity.codmissile.CodMissileModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CodMissileEntityRenderer
extends EntityRenderer<CodMissileEntity> {
    private final CodMissileModel model;

    public CodMissileEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new CodMissileModel(context.bakeLayer(CodMissileModel.LAYER_LOCATION));
    }

    public void render(CodMissileEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0, 3.7, 0.0);
        double x = Mth.lerp((double)partialTick, (double)entity.xOld, (double)entity.getX());
        double y = Mth.lerp((double)partialTick, (double)entity.yOld, (double)entity.getY());
        double z = Mth.lerp((double)partialTick, (double)entity.zOld, (double)entity.getZ());
        poseStack.translate(x - entity.getX(), y - entity.getY(), z - entity.getZ());
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(-entity.getYRot()));
        poseStack.mulPose(Axis.XP.rotationDegrees(entity.getXRot()));
        poseStack.scale(2.5f, 2.5f, 2.5f);
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity))), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(CodMissileEntity codMissileEntity) {
        return ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/entity/codmissile.png");
    }
}

