/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.friendlyFace;

import com.mc3699.codmod.entity.friendlyFace.AttackForTimeGoal;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FriendlyFaceEntity
extends PathfinderMob {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ResourceLocation nullParticleID = ResourceLocation.fromNamespaceAndPath((String)"thebrokenscript", (String)"null_particle");
    public int chaseTime = 200;
    ParticleType<?> nullParticle = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(this.nullParticleID);

    public FriendlyFaceEntity(EntityType<FriendlyFaceEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 22.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AttackForTimeGoal(this, this.level(), 16.0, 2.0));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        super.registerGoals();
    }

    public void tick() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.tickCount % 10 == 0) {
                ParticleOptions particle = (ParticleOptions)this.nullParticle;
                serverLevel.sendParticles(particle, this.position().x, this.position().y, this.position().z, 3, 0.0, 0.0, 0.0, (double)0.2f);
            }
        }
        super.tick();
    }
}

