/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.swarmCod;

import com.mc3699.codmod.entity.swarmCod.SwarmCodEntity;
import com.mc3699.codmod.entity.swarmCod.SwarmCodMoveControl;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;

public class SwarmCodAttackGoal
extends Goal {
    private final SwarmCodEntity mob;
    private LivingEntity target;
    private int attackTime;

    public SwarmCodAttackGoal(SwarmCodEntity mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && this.target.isAlive() && this.mob.distanceToSqr((Entity)this.target) < 128.0;
    }

    public void start() {
        this.attackTime = 0;
    }

    public void tick() {
        ++this.attackTime;
        if (this.mob.onGround() && this.target != null) {
            double dx = this.target.getX() - this.mob.getX();
            double dz = this.target.getZ() - this.mob.getZ();
            float yRot = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            MoveControl moveControl = this.mob.getMoveControl();
            if (moveControl instanceof SwarmCodMoveControl) {
                SwarmCodMoveControl moveControl2 = (SwarmCodMoveControl)moveControl;
                moveControl2.setWantedMovement(yRot, this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED));
            }
            if (this.mob.distanceToSqr((Entity)this.target) < 3.0) {
                this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.PHANTOM_BITE, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.target.hurt(this.mob.level().damageSources().mobAttack((LivingEntity)this.mob), (float)this.mob.getAttributeValue(Attributes.ATTACK_DAMAGE));
                this.attackTime = 0;
            }
        }
    }
}

