/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.swarmCod;

import com.mc3699.codmod.entity.swarmCod.SwarmCodAttackGoal;
import com.mc3699.codmod.entity.swarmCod.SwarmCodMoveControl;
import com.mc3699.codmod.registry.CodEntities;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SwarmCodEntity
extends PathfinderMob {
    public SwarmCodEntity(EntityType<? extends Mob> type, Level level) {
        super((EntityType)CodEntities.SWARM_COD.get(), level);
        this.moveControl = new SwarmCodMoveControl((Mob)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 10.0).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction callback) {
        if (!this.isRemoved()) {
            Vec3 offset = new Vec3(0.0, 0.5, 0.2);
            Vec3 riderPos = this.position().add(offset.x, (double)this.getBbHeight() + offset.y, offset.z).add(new Vec3(0.25, -1.5, offset.z - 0.5).yRot((float)Math.toRadians(-this.getYRot())));
            callback.accept(passenger, riderPos.x, riderPos.y, riderPos.z);
        }
    }

    protected void registerGoals() {
        Predicate<LivingEntity> targetPredicate = livingEntity -> livingEntity.isAlive() && !(livingEntity instanceof SwarmCodEntity);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new SwarmCodAttackGoal(this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, targetPredicate));
    }

    public Vec3 getMovementDirectionToEntity(LivingEntity target, double speed) {
        double dz;
        if (target == null) {
            return Vec3.ZERO;
        }
        double dx = target.getX() - this.getX();
        double distance = Math.sqrt(dx * dx + (dz = target.getZ() - this.getZ()) * dz);
        if (distance < 1.0E-7) {
            return Vec3.ZERO;
        }
        double normalizedX = dx / distance;
        double normalizedZ = dz / distance;
        return new Vec3(normalizedX * speed, 0.0, normalizedZ * speed);
    }
}

