/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.uav;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class UAVEntity
extends Entity {
    private static final EntityDataAccessor<Float> ALTITUDE = SynchedEntityData.defineId(UAVEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.defineId(UAVEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> CIRCLE_RADIUS = SynchedEntityData.defineId(UAVEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> TERRAIN_FOLLOWING = SynchedEntityData.defineId(UAVEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final float DEFAULT_ALTITUDE = 50.0f;
    private static final float DEFAULT_SPEED = 1.0f;
    private static final float DEFAULT_CIRCLE_RADIUS = 50.0f;
    private static final float ALTITUDE_SMOOTHING = 0.0125f;
    private BlockPos linkedController = BlockPos.ZERO;
    private Vec3 targetPos = null;
    private boolean isCircling = false;
    private float targetPitch = 0.0f;
    private ChunkPos[] previousChunks = null;

    public UAVEntity(EntityType<UAVEntity> type, Level level) {
        super(type, level);
        this.entityData.set(ALTITUDE, (Object)Float.valueOf(50.0f));
        this.entityData.set(SPEED, (Object)Float.valueOf(1.0f));
        this.entityData.set(CIRCLE_RADIUS, (Object)Float.valueOf(50.0f));
        this.entityData.set(TERRAIN_FOLLOWING, (Object)true);
        this.setNoGravity(true);
    }

    public boolean isCircling() {
        return this.isCircling;
    }

    public void setCircling(boolean circling) {
        this.isCircling = circling;
    }

    public boolean isAtTarget(int threshold) {
        if (this.targetPos == null) {
            return false;
        }
        Vec3 currentPos = this.position();
        double horizontalDistance = Math.sqrt(Math.pow(currentPos.x - this.targetPos.x, 2.0) + Math.pow(currentPos.z - this.targetPos.z, 2.0));
        return horizontalDistance < (double)threshold;
    }

    public void setTargetPos(Vec3 target) {
        this.targetPos = target;
        this.isCircling = false;
    }

    public void setAltitude(float altitude) {
        this.entityData.set(ALTITUDE, (Object)Float.valueOf(altitude));
    }

    public void setSpeed(float speed) {
        this.entityData.set(SPEED, (Object)Float.valueOf(speed));
    }

    public void setCircleRadius(float radius) {
        this.entityData.set(CIRCLE_RADIUS, (Object)Float.valueOf(radius));
    }

    public boolean isTerrainFollowing() {
        return (Boolean)this.entityData.get(TERRAIN_FOLLOWING);
    }

    public void setTerrainFollowing(boolean enabled) {
        this.entityData.set(TERRAIN_FOLLOWING, (Object)enabled);
    }

    public void tick() {
        Level level;
        ServerLevel serverLevel;
        Level level2;
        if (!this.level().isClientSide && (level2 = this.level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level2;
            ChunkPos currentChunkPos = this.chunkPosition();
            ChunkPos[] currentChunks = new ChunkPos[]{currentChunkPos, new ChunkPos(currentChunkPos.x - 1, currentChunkPos.z - 1), new ChunkPos(currentChunkPos.x - 1, currentChunkPos.z), new ChunkPos(currentChunkPos.x - 1, currentChunkPos.z + 1), new ChunkPos(currentChunkPos.x, currentChunkPos.z - 1), new ChunkPos(currentChunkPos.x, currentChunkPos.z + 1), new ChunkPos(currentChunkPos.x + 1, currentChunkPos.z - 1), new ChunkPos(currentChunkPos.x + 1, currentChunkPos.z), new ChunkPos(currentChunkPos.x + 1, currentChunkPos.z + 1)};
            if (this.previousChunks != null) {
                for (ChunkPos prev : this.previousChunks) {
                    serverLevel.setChunkForced(prev.x, prev.z, false);
                }
            }
            for (ChunkPos chunk : currentChunks) {
                serverLevel.setChunkForced(chunk.x, chunk.z, true);
            }
            this.previousChunks = currentChunks;
        }
        if (!this.level().isClientSide && this.targetPos != null) {
            Vec3 currentPos = this.position();
            float speed = ((Float)this.entityData.get(SPEED)).floatValue();
            if (!this.isCircling) {
                Vec3 direction = this.targetPos.subtract(currentPos).normalize();
                double horizontalDistance = Math.sqrt(Math.pow(currentPos.x - this.targetPos.x, 2.0) + Math.pow(currentPos.z - this.targetPos.z, 2.0));
                if (horizontalDistance > 0.5) {
                    double targetY;
                    Vec3 motion = direction.scale((double)speed);
                    this.move(MoverType.SELF, motion);
                    if (((Boolean)this.entityData.get(TERRAIN_FOLLOWING)).booleanValue()) {
                        BlockPos groundPos = new BlockPos((int)this.position().x, (int)this.position().y, (int)this.position().z);
                        int groundY = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, groundPos).getY();
                        targetY = (float)groundY + ((Float)this.entityData.get(ALTITUDE)).floatValue();
                    } else {
                        targetY = this.targetPos.y;
                    }
                    double currentY = this.position().y;
                    double newY = currentY + (targetY - currentY) * (double)0.0125f;
                    this.setPos(this.position().x, newY, this.position().z);
                    float yaw = (float)(Math.atan2(direction.z, direction.x) * 180.0 / Math.PI);
                    this.setYRot(yaw);
                } else {
                    this.isCircling = true;
                }
            } else {
                double targetY;
                float radius = ((Float)this.entityData.get(CIRCLE_RADIUS)).floatValue();
                float angularSpeed = speed / radius;
                double angle = (double)((float)this.tickCount * angularSpeed) % (Math.PI * 2);
                double centerX = this.targetPos.x;
                double centerZ = this.targetPos.z;
                double x = centerX + (double)radius * Math.cos(angle);
                double z = centerZ + (double)radius * Math.sin(angle);
                if (((Boolean)this.entityData.get(TERRAIN_FOLLOWING)).booleanValue()) {
                    BlockPos groundPos = new BlockPos((int)x, (int)this.position().y, (int)z);
                    int groundY = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, groundPos).getY();
                    targetY = (float)groundY + ((Float)this.entityData.get(ALTITUDE)).floatValue();
                } else {
                    targetY = this.targetPos.y;
                }
                double currentY = this.position().y;
                double newY = currentY + (targetY - currentY) * (double)0.0125f;
                this.setPos(x, newY, z);
                float yaw = (float)(angle * 180.0 / Math.PI + 90.0);
                this.setYRot(yaw);
                this.targetPitch = 0.0f;
                this.setXRot(this.targetPitch);
            }
        }
        if ((level = this.level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, this.position().x, this.position().y + 0.75, this.position().z, 20, 0.0, 0.0, 0.0, 0.0);
        }
        super.tick();
    }

    public void remove(Entity.RemovalReason reason) {
        ChunkPos[] chunkPosArray;
        if (!this.level().isClientSide && (chunkPosArray = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)chunkPosArray;
            if (this.previousChunks != null) {
                for (ChunkPos chunk : this.previousChunks) {
                    serverLevel.setChunkForced(chunk.x, chunk.z, false);
                }
            }
        }
        super.remove(reason);
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean isInvulnerable() {
        return true;
    }

    public boolean shouldBeSaved() {
        return true;
    }

    public void setLinkedController(BlockPos pos) {
        this.linkedController = pos;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ALTITUDE, (Object)Float.valueOf(50.0f));
        builder.define(SPEED, (Object)Float.valueOf(1.0f));
        builder.define(CIRCLE_RADIUS, (Object)Float.valueOf(50.0f));
        builder.define(TERRAIN_FOLLOWING, (Object)true);
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        int linkedX = compoundTag.getInt("controllerX");
        int linkedY = compoundTag.getInt("controllerY");
        int linkedZ = compoundTag.getInt("controllerZ");
        this.linkedController = new BlockPos(linkedX, linkedY, linkedZ);
        this.entityData.set(ALTITUDE, (Object)Float.valueOf(compoundTag.getFloat("altitude")));
        this.entityData.set(SPEED, (Object)Float.valueOf(compoundTag.getFloat("speed")));
        this.entityData.set(CIRCLE_RADIUS, (Object)Float.valueOf(compoundTag.getFloat("circleRadius")));
        this.entityData.set(TERRAIN_FOLLOWING, (Object)compoundTag.getBoolean("terrainFollowing"));
        if (compoundTag.contains("targetX")) {
            this.targetPos = new Vec3(compoundTag.getDouble("targetX"), compoundTag.getDouble("targetY"), compoundTag.getDouble("targetZ"));
        }
        this.isCircling = compoundTag.getBoolean("isCircling");
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt("controllerX", this.linkedController.getX());
        compoundTag.putInt("controllerY", this.linkedController.getY());
        compoundTag.putInt("controllerZ", this.linkedController.getZ());
        compoundTag.putFloat("altitude", ((Float)this.entityData.get(ALTITUDE)).floatValue());
        compoundTag.putFloat("speed", ((Float)this.entityData.get(SPEED)).floatValue());
        compoundTag.putFloat("circleRadius", ((Float)this.entityData.get(CIRCLE_RADIUS)).floatValue());
        compoundTag.putBoolean("terrainFollowing", ((Boolean)this.entityData.get(TERRAIN_FOLLOWING)).booleanValue());
        if (this.targetPos != null) {
            compoundTag.putDouble("targetX", this.targetPos.x);
            compoundTag.putDouble("targetY", this.targetPos.y);
            compoundTag.putDouble("targetZ", this.targetPos.z);
        }
        compoundTag.putBoolean("isCircling", this.isCircling);
    }
}

