/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item.transponder;

import com.mc3699.codmod.network.OpenScreenPayload;
import com.mc3699.codmod.registry.CodComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class TransponderItem
extends Item {
    public TransponderItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenScreenPayload("transponder"), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(usedHand));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (stack.get(CodComponents.TRANSPONDER_ID) != null) {
            tooltipComponents.add((Component)Component.literal((String)("Transponder ID: " + (String)stack.get(CodComponents.TRANSPONDER_ID))).withStyle(ChatFormatting.GREEN));
        } else {
            tooltipComponents.add((Component)Component.literal((String)"[!ID NOT SET!]").withStyle(ChatFormatting.RED));
        }
    }

    public static String getID(ItemStack stack) {
        if (stack.get(CodComponents.TRANSPONDER_ID) != null) {
            return (String)stack.get(CodComponents.TRANSPONDER_ID);
        }
        return "DEFAULT";
    }

    public static void setID(ItemStack stack, String id) {
        stack.set(CodComponents.TRANSPONDER_ID, (Object)id);
    }
}

