/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.peripheral;

import com.mc3699.codmod.block.launchpad.LaunchPadBlockEntity;
import com.mc3699.codmod.entity.codmissile.CodMissileEntity;
import com.mc3699.codmod.registry.CodEntities;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jspecify.annotations.Nullable;

public class LaunchPadPeripheral
implements IPeripheral {
    private final LaunchPadBlockEntity blockEntity;

    public LaunchPadPeripheral(LaunchPadBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    @LuaFunction
    public final void deliver(ILuaContext context, IArguments arguments) throws LuaException {
        int x = arguments.getInt(0);
        int y = arguments.getInt(1);
        int z = arguments.getInt(2);
        if (this.blockEntity.getLevel() != null && !this.blockEntity.getLevel().isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)this.blockEntity.getLevel();
            Vec3 missileSpawnPos = this.blockEntity.getBlockPos().getCenter().add(0.0, 0.1, 0.0);
            CodMissileEntity missileEntity = new CodMissileEntity((EntityType<CodMissileEntity>)((EntityType)CodEntities.COD_MISSILE.get()), (Level)serverLevel, x, y, z, "delivery", null, this.blockEntity.getItems());
            serverLevel.addFreshEntity((Entity)missileEntity);
            missileEntity.setPos(missileSpawnPos);
        }
    }

    @LuaFunction
    public final void fireWithFunction(int x, int y, int z, String type, String argument) {
        if (this.blockEntity.getLevel() != null && !this.blockEntity.getLevel().isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)this.blockEntity.getLevel();
            Vec3 missileSpawnPos = this.blockEntity.getBlockPos().getCenter().add(0.0, 0.1, 0.0);
            CodMissileEntity missileEntity = new CodMissileEntity((EntityType<CodMissileEntity>)((EntityType)CodEntities.COD_MISSILE.get()), (Level)serverLevel, x, y, z, type, argument, new ItemStackHandler(27));
            serverLevel.addFreshEntity((Entity)missileEntity);
            missileEntity.setPos(missileSpawnPos);
        }
    }

    public String getType() {
        return "launch_pad";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return false;
    }
}

