/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.recipe;

import com.mc3699.codmod.data.CodDataMaps;
import com.mc3699.codmod.data.SausageData;
import com.mc3699.codmod.registry.CodComponents;
import com.mc3699.codmod.registry.CodItems;
import com.mc3699.codmod.registry.CodRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SausageRecipe
extends CustomRecipe {
    public SausageRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        if (craftingInput.width() < 3 || craftingInput.height() < 3) {
            return false;
        }
        ItemStack center = craftingInput.getItem(1, 1);
        if (!center.is((Item)CodItems.BAGEL.get())) {
            return false;
        }
        for (int i = 0; i < craftingInput.size(); ++i) {
            SausageData data;
            ItemStack stack = craftingInput.getItem(i);
            if (stack.isEmpty() || (data = (SausageData)stack.getItemHolder().getData(CodDataMaps.SAUSAGE_DATA_MAP)) == null) continue;
            return true;
        }
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        int r = 0;
        int g = 0;
        int b = 0;
        int totalFoodItems = 0;
        float totalSaturation = 0.0f;
        int totalHunger = 0;
        float totalDisgust = 0.0f;
        for (int i = 0; i < craftingInput.size(); ++i) {
            SausageData data;
            ItemStack stack = craftingInput.getItem(i);
            if (stack.isEmpty() || (data = (SausageData)stack.getItemHolder().getData(CodDataMaps.SAUSAGE_DATA_MAP)) == null) continue;
            int c = data.color();
            r += c >> 16 & 0xFF;
            g += c >> 8 & 0xFF;
            b += c & 0xFF;
            totalDisgust += data.disgust();
            totalHunger += data.nutrition();
            totalSaturation += data.saturation();
            ++totalFoodItems;
        }
        if (totalFoodItems == 0) {
            return new ItemStack((ItemLike)CodItems.SAUSAGE.get());
        }
        int avgR = r / totalFoodItems;
        int avgG = g / totalFoodItems;
        int avgB = b / totalFoodItems;
        int avgColor = avgR << 16 | avgG << 8 | avgB;
        ItemStack sausage = new ItemStack((ItemLike)CodItems.SAUSAGE.get());
        FoodProperties props = new FoodProperties.Builder().nutrition(totalHunger).saturationModifier(totalSaturation).alwaysEdible().build();
        sausage.set(DataComponents.FOOD, (Object)props);
        sausage.set(CodComponents.SAUSAGE_COLOR, (Object)avgColor);
        return sausage;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return i >= 3 && i1 >= 3;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)CodRecipeSerializers.SAUSAGE_RECIPE_SERIALIZER.get();
    }
}

