/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.technology.foundation;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMachineMenu
extends AbstractContainerMenu {
    protected final BlockEntity blockEntity;
    protected final ContainerData data;
    protected final ContainerLevelAccess access;

    public BaseMachineMenu(@Nullable MenuType<?> menuType, int containerId, BlockEntity blockEntity, ContainerData data, ContainerLevelAccess access) {
        super(menuType, containerId);
        this.blockEntity = blockEntity;
        this.data = data;
        this.access = access;
        this.addDataSlots(data);
    }

    protected void addPlayerInventory(Inventory playerInv, int startX, int startY) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInv, x + y * 9 + 9, startX + x * 18, startY + y * 18));
            }
        }
    }

    protected void addPlayerHotbar(Inventory playerInv, int startX, int y) {
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInv, x, startX + x * 18, y));
        }
    }

    protected void addFullPlayerInventory(Inventory playerInv, int x, int y) {
        this.addPlayerInventory(playerInv, x, y);
        this.addPlayerHotbar(playerInv, x, y + 58);
    }

    public boolean stillValid(Player player) {
        return (Boolean)this.access.evaluate((level, pos) -> {
            BlockState state = level.getBlockState(pos);
            return level.getBlockEntity(pos) == this.blockEntity && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
        }, (Object)true);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = this.getSlot(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack result = stack.copy();
        int containerSlots = this.slots.size() - 36;
        if (index < containerSlots ? !this.moveItemStackTo(stack, containerSlots, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, containerSlots, false)) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return result;
    }
}

