/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.graphicsMonitor;

import com.mc3699.codmod.registry.CodBlockEntities;
import java.awt.image.BufferedImage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class GraphicsMonitorBlockEntity
extends BlockEntity {
    private BufferedImage[] frameBuffers = new BufferedImage[]{new BufferedImage(1024, 1024, 2), new BufferedImage(1024, 1024, 2)};
    private int activeFrameBuffer = 0;

    public BufferedImage getActiveFramebuffer() {
        return this.frameBuffers[this.activeFrameBuffer];
    }

    public void swapFramebuffer() {
        this.activeFrameBuffer = (this.activeFrameBuffer + 1) % 2;
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("activeBuffer", this.activeFrameBuffer);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("activeBuffer")) {
            this.activeFrameBuffer = tag.getInt("activeBuffer");
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithFullMetadata(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public GraphicsMonitorBlockEntity(BlockPos pos, BlockState blockState) {
        super(CodBlockEntities.GRAPHICS_MONITOR.get(), pos, blockState);
    }
}

