/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.oxygenDistributor;

import com.mc3699.codmod.registry.CodBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class OxygenDistributorBlockEntity
extends BlockEntity {
    private int effectiveArea;
    private boolean shouldRender;

    public OxygenDistributorBlockEntity(BlockPos pos, BlockState blockState) {
        super(CodBlockEntities.OXYGEN_DISTRIBUTOR.get(), pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("range", this.effectiveArea);
        tag.putBoolean("render", this.shouldRender);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.effectiveArea = tag.getInt("range");
        this.shouldRender = tag.getBoolean("render");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putInt("range", this.effectiveArea);
        tag.putBoolean("render", this.shouldRender);
        return tag;
    }

    public void setEffectiveArea(int effectiveArea) {
        this.effectiveArea = effectiveArea;
    }

    public int getEffectiveArea() {
        return this.effectiveArea;
    }

    public void setShouldRender(boolean shouldRender) {
        this.shouldRender = shouldRender;
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean shouldRender() {
        return this.shouldRender;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getGameTime() % 20L == 0L && be instanceof OxygenDistributorBlockEntity) {
            OxygenDistributorBlockEntity distributor = (OxygenDistributorBlockEntity)be;
            int newRange = 0;
            for (int i = 1; i < 6; ++i) {
                BlockState checkState = serverLevel.getBlockState(pos.above(i));
                Vec3 checkedPos = pos.getCenter().add(0.0, (double)i, 0.0);
                if (!checkState.is(BlockTags.LEAVES)) break;
                ++newRange;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CLOUD, checkedPos.x, checkedPos.y, checkedPos.z, 10, 0.0, 0.0, 0.0, 0.05);
            }
            int range = newRange * 6;
            distributor.setEffectiveArea(range);
            distributor.setChanged();
            serverLevel.sendBlockUpdated(pos, state, state, 3);
            AABB searchArea = new AABB(pos).inflate((double)range);
            List nearEntities = serverLevel.getEntitiesOfClass(LivingEntity.class, searchArea);
            for (LivingEntity entity : nearEntities) {
                if (!(pos.getCenter().distanceTo(entity.position()) < (double)range)) continue;
                CompoundTag tag = entity.getPersistentData();
                tag.putInt("oxygen_saturation", 300);
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

