/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.server;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ServerBlock
extends Block {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty IS_TOP = BooleanProperty.create((String)"is_top");
    public static final BooleanProperty ONLINE = BooleanProperty.create((String)"online");
    public static final BooleanProperty IS_CONTROLLER = BooleanProperty.create((String)"controller");

    public ServerBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)IS_TOP, (Comparable)Boolean.valueOf(true)));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ONLINE, (Comparable)Boolean.valueOf(false)));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)IS_CONTROLLER, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{IS_TOP});
        builder.add(new Property[]{ONLINE});
        builder.add(new Property[]{IS_CONTROLLER});
        super.createBlockStateDefinition(builder);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Player player = pContext.getPlayer();
        Direction facing = Direction.NORTH;
        if (player != null) {
            Direction blockFacing = Direction.fromYRot((double)player.getYRot());
            facing = blockFacing.getOpposite();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        ServerLevel serverLevel;
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getBlockState(pos.below()).getBlock().equals((Object)this) && ((Boolean)serverLevel.getBlockState(pos.below()).getValue((Property)IS_TOP)).booleanValue()) {
            BlockState newState = (BlockState)state.setValue((Property)IS_TOP, (Comparable)Boolean.valueOf(false));
            serverLevel.setBlock(pos.below(), newState, 3);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.getBlockState(pos.below()).getBlock().equals((Object)this)) {
                serverLevel.destroyBlock(pos.below(), true);
            }
            if (serverLevel.getBlockState(pos.above()).getBlock().equals((Object)this)) {
                serverLevel.destroyBlock(pos.above(), true);
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getBlockState(pos.below()).getBlock().equals((Object)this) && !((Boolean)serverLevel.getBlockState(pos.below()).getValue((Property)IS_TOP)).booleanValue()) {
            if (((Boolean)state.getValue((Property)ONLINE)).booleanValue()) {
                BlockState topState = (BlockState)state.setValue((Property)ONLINE, (Comparable)Boolean.valueOf(false));
                serverLevel.setBlock(pos, topState, 3);
                BlockState bottomState = (BlockState)((BlockState)state.setValue((Property)ONLINE, (Comparable)Boolean.valueOf(false))).setValue((Property)IS_TOP, (Comparable)Boolean.valueOf(false));
                serverLevel.setBlock(pos.below(), bottomState, 3);
            } else {
                BlockState topState = (BlockState)state.setValue((Property)ONLINE, (Comparable)Boolean.valueOf(true));
                serverLevel.setBlock(pos, topState, 3);
                BlockState bottomState = (BlockState)((BlockState)state.setValue((Property)ONLINE, (Comparable)Boolean.valueOf(true))).setValue((Property)IS_TOP, (Comparable)Boolean.valueOf(false));
                serverLevel.setBlock(pos.below(), bottomState, 3);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }
}

