/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanListEntry;

public class TempBanCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"tempban").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"hours", (ArgumentType)IntegerArgumentType.integer((int)1)).then(((RequiredArgumentBuilder)Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).requires(dis -> dis.hasPermission(3))).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"player");
            int hours = IntegerArgumentType.getInteger((CommandContext)context, (String)"hours");
            String reason = StringArgumentType.getString((CommandContext)context, (String)"reason");
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            Date banExpiry = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(banExpiry);
            calendar.add(10, hours);
            banExpiry = calendar.getTime();
            Optional profile = server.getProfileCache().get(name);
            if (profile.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Player not found: " + name)));
                return 0;
            }
            UserBanListEntry entry = new UserBanListEntry((GameProfile)profile.get(), new Date(), ((CommandSourceStack)context.getSource()).getPlayer().getName().getString(), banExpiry, reason);
            server.getPlayerList().getBans().add((StoredUserEntry)entry);
            ServerPlayer serverplayer = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(((GameProfile)profile.get()).getId());
            if (serverplayer != null) {
                serverplayer.connection.disconnect((Component)Component.literal((String)"You have been temp-banned, join again for details."));
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Banned " + name + " for " + hours + " hours: " + reason)), true);
            return 1;
        })))));
    }
}

