/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.applicant;

import com.mc3699.codmod.handlers.BackroomsEvents;
import com.mc3699.codmod.registry.CodDamageTypes;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ApplicantEntity
extends PathfinderMob {
    public ApplicantEntity(EntityType<ApplicantEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
        this.goalSelector.addGoal(2, (Goal)new OpenDoorGoal((Mob)this, false));
    }

    public void tick() {
        Level level;
        super.tick();
        if (this.level().dimension().equals(BackroomsEvents.BACKROOMS_DIM) && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BackroomsEvents.flicker(serverLevel, this.blockPosition(), 16, 0.5f);
        }
    }

    public boolean doHurtTarget(Entity entity) {
        DamageSource damageSource = new DamageSource((Holder)this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(CodDamageTypes.JOB_APPLICATION), (Entity)this);
        return entity.hurt(damageSource, 15.0f);
    }
}

