/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.cod_almighty;

import com.mc3699.codmod.entity.cod_almighty.CodAlmightyEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;

public class CodAlmightyRandomFlyGoal
extends Goal {
    protected final CodAlmightyEntity cod;
    protected final double speed;
    protected int nextMoveTime;

    public CodAlmightyRandomFlyGoal(CodAlmightyEntity cod, double speed) {
        this.cod = cod;
        this.speed = speed;
        this.nextMoveTime = 0;
    }

    public boolean canContinueToUse() {
        return this.cod.getMoveControl().hasWanted();
    }

    public boolean canUse() {
        return true;
    }

    public void tick() {
        Level level = this.cod.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.cod.tickCount % 213 == 0) {
                RandomSource random = this.cod.getRandom();
                double x = this.cod.getX() + (random.nextDouble() * 128.0 - 64.0);
                double y = serverLevel.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, this.cod.getOnPos()).above(15).getY();
                double z = this.cod.getZ() + (random.nextDouble() * 128.0 - 64.0);
                this.cod.getNavigation().moveTo(x, y, z, 1.0);
            }
        }
    }
}

