/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.cod_almighty;

import com.mc3699.codmod.entity.cod_almighty.CodAlmightyEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;

public class CodAlmightyShootGoal
extends Goal {
    private final CodAlmightyEntity cod;
    private int attackTime;

    public CodAlmightyShootGoal(CodAlmightyEntity cod) {
        this.cod = cod;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean canUse() {
        LivingEntity target = this.cod.getTarget();
        return target != null && target.isAlive();
    }

    public void start() {
        this.attackTime = 30;
    }

    public void tick() {
        Level level;
        LivingEntity target = this.cod.getTarget();
        if (target == null) {
            return;
        }
        if (--this.attackTime <= 0 && !(level = this.cod.level()).isClientSide()) {
            double dx = target.getX() - this.cod.getX();
            double dy = target.getY(0.5) - this.cod.getY(0.5);
            double dz = target.getZ() - this.cod.getZ();
            LargeFireball proj = new LargeFireball(EntityType.FIREBALL, level);
            proj.setPos(this.cod.getX(), this.cod.getY(0.5) + 0.5, this.cod.getZ());
            proj.shoot(dx, dy, dz, 1.0f, 0.0f);
            proj.setNoGravity(true);
            level.addFreshEntity((Entity)proj);
        }
    }
}

