/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.trialTrader;

import com.mc3699.codmod.entity.trialTrader.TrialTraderEntity;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class FollowGarethGoal
extends Goal {
    private final TrialTraderEntity entity;
    UUID MC3699_UUID = UUID.fromString("6479c5ab-902a-4f50-952c-91eeb4552e05");
    UUID GARETH_UUID = UUID.fromString("1c1f8991-0677-4a81-bc79-aedb0cdc907c");
    Random random = new Random();
    private Player targetPlayer;

    public FollowGarethGoal(TrialTraderEntity entity) {
        this.entity = entity;
    }

    public boolean canUse() {
        this.targetPlayer = this.entity.level().getPlayerByUUID(this.GARETH_UUID);
        return this.targetPlayer != null && !this.targetPlayer.isSpectator() && this.targetPlayer.distanceTo((Entity)this.entity) < 16.0f;
    }

    public boolean canContinueToUse() {
        return this.targetPlayer != null || this.targetPlayer.distanceTo((Entity)this.entity) > 32.0f;
    }

    public void tick() {
        Level level;
        if (this.targetPlayer != null && (level = this.entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.entity.getNavigation().moveTo((Entity)this.targetPlayer, 1.5);
            this.entity.getLookControl().setLookAt((Entity)this.targetPlayer);
            if (this.targetPlayer.distanceTo((Entity)this.entity) < 3.0f) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, this.entity.position().x, this.entity.position().y + (double)1.8f, this.entity.position().z, 3, 0.0, (double)0.3f, 0.0, (double)0.2f);
            }
        }
    }

    public void stop() {
        this.entity.getNavigation().stop();
        this.targetPlayer = null;
    }
}

