/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.event;

import com.mc3699.codmod.registry.CodEntities;
import dev.wendigodrip.thebrokenscript.api.event.BaseEvent;
import dev.wendigodrip.thebrokenscript.api.ext.EntityTypeExt;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class DarkenerEvent
extends BaseEvent {
    public DarkenerEvent() {
        super(1);
    }

    private void spawnDarkener(ServerPlayer player, ServerLevel level, int radius) {
        RandomSource random = level.random;
        int maxAttempts = 20;
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            double theta = random.nextDouble() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * random.nextDouble() - 1.0);
            double distance = random.nextDouble() * (double)radius;
            double x = player.getX() + distance * Math.sin(phi) * Math.cos(theta);
            double y = player.getY() + (random.nextDouble() - 0.5) * (double)radius;
            double z = player.getZ() + distance * Math.sin(phi) * Math.sin(theta);
            y = Math.max((double)(level.getMinBuildHeight() + 2), Math.min(63.0, y));
            BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
            if (!level.getBlockState(pos).isAir() || level.canSeeSky(pos)) continue;
            EntityTypeExt.INSTANCE.trySummon((EntityType)CodEntities.DARKENER.get(), (LevelAccessor)level, pos.getCenter().add(0.5, 0.0, 0.5));
        }
    }

    public void execute(ServerLevel level, ServerPlayer player, Vec3 vec3) {
        level.players().forEach(victim -> {
            RandomSource random = level.random;
            if (random.nextInt(0, 10) > 8) {
                level.getSunAngle(0.0f);
                this.spawnDarkener((ServerPlayer)victim, level, 10);
            }
        });
    }
}

