/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import com.mc3699.codmod.entity.itemProjectile.ItemProjectileEntity;
import com.mc3699.codmod.registry.CodEntities;
import com.mc3699.codmod.registry.CodItems;
import com.mc3699.codmod.registry.CodSounds;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class NullChickenSwordItem
extends SwordItem {
    public NullChickenSwordItem(Item.Properties properties) {
        super((Tier)Tiers.NETHERITE, properties);
    }

    public float getAttackDamageBonus(Entity target, float damage, DamageSource damageSource) {
        return damage * 13.0f;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"ERR.NULLCHICKEN"));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        for (int i = 0; i < 2; ++i) {
            ItemStack randomStack = new ItemStack((ItemLike)CodItems.NULL_CHICKEN.get(), 10);
            ItemProjectileEntity projectile = new ItemProjectileEntity((EntityType<? extends ItemProjectileEntity>)((EntityType)CodEntities.ITEM_PROJECTILE.get()), level, randomStack, 5, 10, false);
            Vec3 eyePos = player.getEyePosition();
            Vec3 lookVec = player.getViewVector(1.0f).normalize().scale(0.8);
            projectile.setPos(eyePos.x + lookVec.x, eyePos.y + lookVec.y, eyePos.z + lookVec.z);
            projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 1.0f, 2.5f, 4.0f);
            level.addFreshEntity((Entity)projectile);
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.playSound(null, player.blockPosition(), (SoundEvent)CodSounds.NULL_CHICKEN_BLAST.value(), SoundSource.MASTER, 2.0f, 1.0f);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
    }
}

