/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import com.mc3699.codmod.registry.CodSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;

public class PsycheEthosGunItem
extends Item {
    public PsycheEthosGunItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"Made for Mgwew2").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.literal((String)"Model by Reverister").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.literal((String)"Implemented by Deli_Shoes").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        Level level2 = player.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            ItemStack ammo = null;
            if (player.hasInfiniteMaterials()) {
                this.fireRaycast(serverLevel, player);
                serverLevel.playSound(null, player.blockPosition(), (SoundEvent)CodSounds.GUNSHOT.value(), SoundSource.MASTER, 1.0f, 1.0f);
                player.getCooldowns().addCooldown((Item)this, 20);
            } else if (player.getInventory().contains(Tags.Items.NUGGETS)) {
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack itemstack1 = player.getInventory().getItem(i);
                    if (!itemstack1.is(Tags.Items.NUGGETS)) continue;
                    ammo = itemstack1;
                }
                if (ammo != null) {
                    ammo.shrink(1);
                    this.fireRaycast(serverLevel, player);
                    serverLevel.playSound(null, player.blockPosition(), (SoundEvent)CodSounds.GUNSHOT.value(), SoundSource.MASTER, 1.0f, 1.0f);
                    player.getCooldowns().addCooldown(this.asItem(), 20);
                }
            }
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
    }

    private void fireRaycast(ServerLevel serverLevel, Player player) {
        double maxRange = 250.0;
        Vec3 start = player.getEyePosition(1.0f);
        Vec3 angle = player.getLookAngle().scale(maxRange);
        Vec3 end = start.add(angle.scale(maxRange));
        BlockHitResult blockHitResult = serverLevel.clip(new ClipContext(start, angle, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        AABB hitZone = player.getBoundingBox().expandTowards(angle.scale(maxRange));
        EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)start, (Vec3)end, (AABB)hitZone, entity -> true, (double)1.0E9);
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.CRIT, (start.x + end.x) / 2.0, (start.y + end.y) / 2.0, (start.z + end.z) / 2.0, 10, (end.x - start.x) / 2.0, (end.y - start.y) / 2.0, (end.z - start.z) / 2.0, 0.1);
        if (hitResult != null) {
            hitResult.getEntity().hurt(serverLevel.damageSources().playerAttack(player), 10.0f);
        }
    }
}

