/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item.designator;

import com.mc3699.codmod.network.OpenScreenPayload;
import com.mc3699.codmod.registry.CodComponents;
import com.mc3699.codmod.registry.CodItems;
import com.mc3699.codmod.registry.CodSounds;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.Packet;
import dan200.computercraft.api.network.PacketSender;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class DesignatorItem
extends Item {
    public DesignatorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        ItemStack stack = player.getItemInHand(player.getUsedItemHand());
        if (stack.getItem() instanceof DesignatorItem && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!player.isShiftKeyDown()) {
                    int rednetChannel = (Integer)stack.getOrDefault(CodComponents.CHANNEL, (Object)1000);
                    BlockPos clicked = context.getClickedPos();
                    HashMap<String, Integer> sendPos = new HashMap<String, Integer>();
                    sendPos.put("x", clicked.getX());
                    sendPos.put("y", clicked.getY());
                    sendPos.put("z", clicked.getZ());
                    serverLevel.playSound(null, player.getBlockPosBelowThatAffectsMyMovement(), (SoundEvent)CodSounds.DESIGNATE_TARGET.value(), SoundSource.MASTER);
                    player.getCooldowns().addCooldown((Item)CodItems.DESIGNATOR.get(), 20);
                    this.sendMessage(serverLevel, rednetChannel, sendPos, player.position());
                    return InteractionResult.PASS;
                }
            }
            if (player.isShiftKeyDown()) {
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenScreenPayload("designator"), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return InteractionResult.FAIL;
    }

    private void sendMessage(final ServerLevel serverLevel, int rednetChannel, Map<String, Integer> sendPos, final Vec3 txPos) {
        ComputerCraftAPI.getWirelessNetwork((MinecraftServer)serverLevel.getServer()).transmitSameDimension(new Packet(rednetChannel, rednetChannel, sendPos, new PacketSender(){

            public Level getLevel() {
                return serverLevel;
            }

            public Vec3 getPosition() {
                return txPos;
            }

            public String getSenderID() {
                return "designator";
            }
        }), 10000.0);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)("Channel: " + String.valueOf(stack.getOrDefault(CodComponents.CHANNEL, (Object)1000)))).withStyle(ChatFormatting.GRAY));
    }

    public static void setChannel(ItemStack stack, int channel) {
        stack.set(CodComponents.CHANNEL, (Object)channel);
    }

    public static int getChannel(ItemStack stack) {
        return (Integer)stack.getOrDefault(CodComponents.CHANNEL, (Object)1000);
    }
}

