/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.mixin;

import com.mc3699.codmod.dimension.DimensionKeys;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class PlanetRenderMixins {
    @Shadow
    @Nullable
    private ClientLevel level;

    @Shadow
    protected abstract void createStars();

    @Shadow
    protected abstract void createDarkSky();

    @Shadow
    protected abstract void renderEndSky(PoseStack var1);

    @Shadow
    public abstract void renderSky(Matrix4f var1, Matrix4f var2, float var3, Camera var4, boolean var5, Runnable var6);

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")}, cancellable=true)
    private void stopRendering(PoseStack poseStack, Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        if (this.level != null && this.level.dimension() == DimensionKeys.ENTROPY) {
            ci.cancel();
        }
    }

    @Inject(method={"renderSky"}, at={@At(value="HEAD")}, cancellable=true)
    private void noSky(Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        if (this.level != null && this.level.dimension() == DimensionKeys.ENTROPY) {
            Vec3 fog = this.level.getSkyColor(camera.getPosition(), partialTick);
            float r = (float)(fog.x * (double)0.4f);
            float g = (float)(fog.y * (double)0.4f);
            float b = (float)(fog.z * (double)0.4f);
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)0.5f);
            PoseStack poseStack = new PoseStack();
            this.renderEndSky(poseStack);
            poseStack.mulPose(frustumMatrix);
            Tesselator tesselator = Tesselator.getInstance();
            float celestialAngle = this.level.getTimeOfDay(partialTick) * 360.0f;
            poseStack.mulPose(Axis.ZP.rotationDegrees(celestialAngle));
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            float f12 = 500.0f;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/environment/blue_sun.png"));
            BufferBuilder bufferbuilder1 = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            Matrix4f matrix4f = poseStack.last().pose();
            bufferbuilder1.addVertex(matrix4f, -f12, 500.0f, -f12).setUv(0.0f, 0.0f);
            bufferbuilder1.addVertex(matrix4f, f12, 500.0f, -f12).setUv(1.0f, 0.0f);
            bufferbuilder1.addVertex(matrix4f, f12, 500.0f, f12).setUv(1.0f, 1.0f);
            bufferbuilder1.addVertex(matrix4f, -f12, 500.0f, f12).setUv(0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder1.buildOrThrow());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            ci.cancel();
        }
        if (this.level != null && this.level.dimension() == DimensionKeys.BOREAS) {
            PoseStack poseStack = new PoseStack();
            poseStack.mulPose(frustumMatrix);
            Tesselator tesselator = Tesselator.getInstance();
            float celestialAngle = this.level.getTimeOfDay(partialTick) * 360.0f;
            poseStack.mulPose(Axis.ZP.rotationDegrees(celestialAngle));
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            float f12 = 10.0f;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/environment/blue_sun.png"));
            BufferBuilder bufferbuilder1 = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            Matrix4f matrix4f = poseStack.last().pose();
            bufferbuilder1.addVertex(matrix4f, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
            bufferbuilder1.addVertex(matrix4f, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
            bufferbuilder1.addVertex(matrix4f, f12, 100.0f, f12).setUv(1.0f, 1.0f);
            bufferbuilder1.addVertex(matrix4f, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder1.buildOrThrow());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            ci.cancel();
        }
    }
}

