/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.peripheral;

import com.mc3699.codmod.block.radar.RadarBlockEntity;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class RadarPeripheral
implements IPeripheral {
    private final RadarBlockEntity blockEntity;

    public RadarPeripheral(RadarBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public String getType() {
        return "radar";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return false;
    }

    @LuaFunction
    public Map<String, Object> scan(IComputerAccess computer) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Level level = this.blockEntity.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (Player player : serverLevel.getServer().getPlayerList().getPlayers()) {
                if (player.level().dimension() != this.blockEntity.getLevel().dimension()) continue;
                Vec3 pos = player.position();
                HashMap<String, Double> coords = new HashMap<String, Double>();
                coords.put("x", pos.x);
                coords.put("y", pos.y);
                coords.put("z", pos.z);
                result.put(player.getName().getString(), coords);
            }
        }
        return result;
    }

    @LuaFunction
    public Map<Integer, Map<String, Double>> getEntitiesByType(String entityTypeId) {
        HashMap<Integer, Map<String, Double>> result = new HashMap<Integer, Map<String, Double>>();
        Level level = this.blockEntity.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityType entityType = EntityType.byString((String)entityTypeId).orElse(null);
            if (entityType != null) {
                int index = 1;
                for (Entity entity : serverLevel.getEntities().getAll()) {
                    if (entity.getType() != entityType || entity.level().dimension() != this.blockEntity.getLevel().dimension()) continue;
                    Vec3 pos = entity.position();
                    HashMap<String, Double> coords = new HashMap<String, Double>();
                    coords.put("x", pos.x);
                    coords.put("y", pos.y);
                    coords.put("z", pos.z);
                    result.put(index++, coords);
                }
            }
        }
        return result;
    }
}

